/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
/*
	Fundamental Graphics Widget	(first written Sept. 7, 1994)
	Based on the Label Widget in pp. 500- of Asente  and Swick.
	This file (paper.c) has the parts that interact with the
	Intrinsics.

	Still under development
*/

#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include "PaperP.h"

/* XtOffsetOf determines byte offset of field within struct */

static XtResource resources[] = {
	{XtNloseSelection, XtCLoseSelection, XtRCallback,
	sizeof(XtCallbackList),
	XtOffsetOf(PaperRec, paper.lose_selection),
	XtRCallback, (XtPointer) NULL },

	{XtNredrawCallback, XtCRedrawCallback,		/* contains function */ 
	XtRCallback, sizeof(XtCallbackList),		/* to redraw window  */
	XtOffsetOf(PaperRec, paper.redrawCallback),
	XtRCallback, (XtPointer) NULL },

	{XtNuserDraw, XtCUserDraw,			/* contains function that */
	XtRFunction, sizeof(XtPointer),		/* is called first from   */
	XtOffsetOf(PaperRec, paper.udraw),		/* within Redisplay	  */
	XtRImmediate, (XtPointer) NULL },

	{XtNuserHandler, XtCUserHandler, 
	XtRFunction, sizeof(XtPointer),
	XtOffsetOf(PaperRec, paper.uhandler),
	XtRImmediate, (XtPointer) NULL },

	{XtNgiveSelection, XtCGiveSelection, 
	XtRFunction, sizeof(XtPointer),
	XtOffsetOf(PaperRec, paper.give_selection),
	XtRImmediate, (XtPointer) NULL },
	0};
	

static void ClassInitialize(), ClassPartInitialize(), Initialize(),
	Redisplay(), Destroy(), Resize(), LoseSelection(),
	display_paper_highlight();

static Boolean SetValues(), AcceptFocus();
/*static*/ Boolean SelectText();

static XtGeometryResult QueryGeometry();

PaperClassRec paperClassRec = {
 /* Core class part */
 /*superclass*/		(WidgetClass) &widgetClassRec,
 /*class_name*/		"Paper",
 /*widget_size*/	sizeof(PaperRec),
 /*class_initialize*/	ClassInitialize,
 /*class_part_initialize*/	ClassPartInitialize,
 /*class_inited*/	FALSE,
 /*initialize*/		Initialize,
 /*initialize_hook*/	NULL,
 /*realize*/		XtInheritRealize,
 /*actions*/		NULL,
 /*num_actions*/	0,
 /*resources*/		resources,
 /*num_resources*/	XtNumber(resources),
 /*xrm_class*/		NULLQUARK,
 /*compress_motion*/	FALSE,		/* needed for rubber banding */
 /*compress_exposure*/	XtExposeCompressMultiple, /*XtExposeNoCompress,*/
 /*compress_enterleave*/	TRUE,
 /*visible_interest*/	FALSE,
 /*destroy*/		Destroy,
 /*resize*/		Resize,
 /*expose*/		Redisplay,
 /*set_values*/		SetValues,
 /*set_values_hook*/	NULL,
 /*set_values_almost*/	XtInheritSetValuesAlmost,
 /*get_values_hook*/	NULL,
 /*accept_focus*/	AcceptFocus,
 /*version*/		XtVersion,
 /*callback_private*/	NULL,
 /*tm_table*/		NULL,
 /*query_geometry*/	QueryGeometry,
 /*display_accelerator*/	NULL,
 /*extension*/		NULL,

/* Paper class part */
 /* select */		SelectText,
 /*extension*/		NULL
};

/* Class record pointer */

WidgetClass paperWidgetClass = (WidgetClass) & paperClassRec;

/* Accept Keyboard Input */

static Boolean AcceptFocus(w, time_p)
	Widget w;
	Time *time_p;
{
	/*	Since the paper widegt always the focus this seems	*/
	/*	superfluous. Execrcised only once - from Ol menu		*/
	printf("AcceptFocus called\n");
	return TRUE;
}

/* No safeguards for the string (too long, etc) in this implementation	*/

Boolean DeliverSelection(w, selection, target, type_r, value_r,
						length_r, format_r)
	Widget w;
	Atom *selection, *target, *type_r;
	XtPointer *value_r;
	unsigned long *length_r;
	int *format_r;
{
	PaperWidget	sw = (PaperWidget)w;
	static Atom	targets = 0;

	if(targets==0)
		targets = XInternAtom(XtDisplay(w), "TARGETS", False);

	printf("Conversion called [s=%d t=%d]\n", *selection, *target);

	if(*target==targets) {
		*type_r = XA_ATOM;
		*value_r = (XtPointer) XtNew(Atom);
		*(Atom *) *value_r = XA_STRING;
		*length_r = 1;
		*format_r = 32;
		printf("Taking atom ... [%d]\n", *value_r);
		return(TRUE);
	}

	if(*target==XA_STRING) {
		*type_r  = XA_STRING;
		if(sw->paper.give_selection)
			sw->paper.give_selection(value_r, length_r);
		else {
			printf("No Selection give defined\n");
			return(FALSE);
		}
		*format_r = 8;
		printf("Taking string ... [%s]\n", *value_r);
		return(TRUE);
	}
	return(FALSE);
}

static void LoseSelection(w, selection)
	Widget w;
	Atom *selection;
{
	PaperWidget	sw = (PaperWidget)w;

	XtCallCallbackList((Widget)sw, sw->paper.lose_selection,
					(XtPointer)selection);
}

/*static*/ Boolean SelectText(w, selection, own)
	Widget w;
	Atom selection;
	Boolean own;
{
	PaperWidget sw = (PaperWidget)w;

	if(own) {
		return XtOwnSelection((Widget)sw, selection,
		XtLastTimestampProcessed(XtDisplay(sw)),
		DeliverSelection, LoseSelection, NULL);
	}
	else {
		XtDisownSelection((Widget)sw, selection,
		XtLastTimestampProcessed(XtDisplay(sw)));
		return TRUE;
	}
}

static void ClassInitialize()
{
}

static void ClassPartInitialize(widget_class)
	WidgetClass widget_class;
{
	register PaperWidgetClass swc = (PaperWidgetClass)widget_class;
	PaperWidgetClass super =
		(PaperWidgetClass) swc->core_class.superclass;

	if(swc->paper_class.select == InheritSelectText ) {
		swc->paper_class.select = super->paper_class.select;
	}
}

static GC GetNormalGC(sw, kind /*1 private, 0 public*/)
	PaperWidget sw;
{
	XGCValues	values;
	Display		*Dp = XtDisplay(sw);
	int		Scr = DefaultScreen(Dp);

	static unsigned long valuemask =
		GCBackground | GCFunction |
		GCLineWidth | GCLineStyle |
		GCForeground | GCGraphicsExposures;

	values.graphics_exposures = False;
	values.foreground = BlackPixel(Dp, Scr);
	values.background = WhitePixel(Dp, Scr);
#ifdef PAST_XOR
	values.function   = GXxor;
	if(values.background)
		values.foreground ^= values.background;
#else
	values.function   = GXcopy;
#endif
	values.line_width = 0;
	values.line_style = LineSolid;

	if(kind) return XtGetGC( (Widget)sw, valuemask, &values);
	else return
		XCreateGC( Dp, DefaultRootWindow(Dp), valuemask, &values);
}

static void Initialize(request, new, args, num_args)
	Widget request, new;
	ArgList args;
	Cardinal *num_args;
{
	PaperWidget sw = (PaperWidget) new;

#ifdef CURIOUS
	printf("Init args = %d\n", *num_args);
#endif

	sw->paper.public_gc	= GetNormalGC(sw, 0);
	sw->paper.private_gc	= GetNormalGC(sw, 1);

	sw->paper.is_active	= FALSE;

	if(sw->core.width  <1) sw->core.width  = 100;
	if(sw->core.height <1) sw->core.height = 100;
}

static Boolean SetValues(old, request, new, args, num_args)
	Widget old, request, new;
	ArgList args;
	Cardinal *num_args;
{
	PaperWidget oldsw = (PaperWidget)old;
	PaperWidget newsw = (PaperWidget)new;
	Boolean redisplay = False;

#ifdef CURIOUS
	printf("SetValue args = %d\n", *num_args);
#endif

#define NE(field)	(oldsw->field != newsw->field)

	/* here we should recompute dimensions, etc, etc */

	return redisplay  || NE(core.border_width);
#undef NE
}

static void Destroy(w)
	Widget w;
{
	PaperWidget sw = (PaperWidget)w;

	XtReleaseGC(w, sw->paper.private_gc);
	XtReleaseGC(w, sw->paper.public_gc);
}

static void Redisplay(w, ep, region)
	Widget w;
	XEvent *ep;
	Region region;
{
	PaperWidget sw = (PaperWidget)w;

	XClearWindow(XtDisplay(sw), XtWindow(sw));

	/*	Provide widget to output destination	*/
	if(sw->paper.udraw) sw->paper.udraw(sw);

	/*	Call User Function[s]	*/
	if(XtHasCallbacks((Widget)sw, XtNredrawCallback)==XtCallbackHasSome)
		XtCallCallbackList((Widget)sw, sw->paper.redrawCallback, NULL);

	if(sw->paper.is_active) display_paper_highlight(sw);
}

static void Resize(w)
	Widget w;
{
	if( XtIsRealized(w) ) {
		XClearWindow(XtDisplay(w), XtWindow(w));

		/* That's redisplay */
		(*(XtClass(w)->core_class.expose))(w,
				(XEvent *)NULL, (Region)NULL);
	}
}

static XtGeometryResult QueryGeometry(w, proposed, desired)
	Widget w;
	XtWidgetGeometry *proposed, *desired;
{
	return XtGeometryNo;
}

/*	Convenience Functions accessing the internal fields	*/

GC paper_gc(sw)
	PaperWidget sw;
{
	return sw->paper.public_gc;
}

GC pr_paper_gc(sw)
	PaperWidget sw;
{
	return sw->paper.private_gc;
}

XtPointer * paper_hanger(sw)
	PaperWidget sw;
{
	return( &(sw->paper.hang) );
}

static void display_paper_highlight(w)	/* also called when area is cleared */
	Widget w;
{
	PaperWidget sw = (PaperWidget)w;

	if(sw->paper.is_active)
		XSetFunction(XtDisplay(sw), sw->paper.private_gc, GXset);
	else
		XSetFunction(XtDisplay(sw), sw->paper.private_gc, GXclear);

	XDrawRectangle(	XtDisplay(sw),  XtWindow(sw), sw->paper.private_gc,
		0, 0, sw->core.width-1, sw->core.height-1);

	XSetFunction(XtDisplay(sw), sw->paper.private_gc, GXxor);
}

paper_highlight(w, n)
	Widget w;
{
	PaperWidget sw = (PaperWidget)w;

	if(n) 	sw->paper.is_active = TRUE;
	else  	sw->paper.is_active = FALSE;
	display_paper_highlight(sw);
}

char *myname(w)
	Widget w;
{
	return w->core.name;
}

/* 
In response to:
      int             (*final_handler)();

event_usage(sw, f)
	PaperWidget sw;
	int (*f)();
{
	sw->paper.final_handler = f;
}

int (*usage_return(sw))()
	PaperWidget sw;
{
	return(sw->paper.final_handler);
}
*/
