/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
/*
	Routines that applications call to use paper widget.
	They know about Xlib, Xt, Widgets but not speciafically
	about paperWidgetClass (almost but they call GC function
	of paper widget)
*/
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Starter.h>

/*     Font Utilities   */
static Display * Dpy;
static int	d_init = 0;

static XGCValues vv;	/* saved values - used in many routines */

#ifdef NEW_C
void set_server(Display *d)
#else
void set_server(d)
	Display *d;
#endif
{
	Dpy =  d;
	d_init = 1;
}

#ifdef NEW_C
void xflush()
#else
void xflush()
#endif
{
	if(d_init) XFlush(Dpy);
}

/*	Declarations of Internal Functions	*/
static void find_font();
static void gen_use_selection();

/*	Drawing Functions	*/
#include <Paper.h>
extern GC	paper_gc();
extern GC	pr_paper_gc();
extern char *	myname();
static Window		c_window;
static GC		c_gc;
static PaperWidget	sw = 0;
static PaperWidget	sw_previous;
static PaperWidget	b_widget = 0;	/* used by work process */
static int		p_init = 0;
/*	The following refer to Application (Selection)	*/
static	Boolean		has_selection =  FALSE;
static	String		label;
static	Position	label_x;
static	Position	label_y;
static	Dimension	label_width;
static	Dimension	label_height;
static	Cardinal	label_len;
static	Dimension	space = 4;	/* for now */
static	PaperWidget	selection_w;	/* too restrictive */

#ifdef NEW_C
int confirm_paper_class(Widget w)
#else
int confirm_paper_class(w)
	Widget w;
#endif
{
	char msg_buffer[256];

	if(XtClass(w) == paperWidgetClass) return True;
	sprintf(msg_buffer,
		"Widget %s cannot be used to draw. It is not Paper Class",
		XtName(w) );
	own_error(0, msg_buffer);
	return False;
}

#ifdef NEW_C
void draw_area(Widget w)
#else
void draw_area(w)
	Widget w;
#endif
{
	if(!w) return;

	if(confirm_paper_class(w) != True) return;

	if(sw==(PaperWidget)w) return;

	if(!d_init) set_server(XtDisplay(w));

#ifdef HIGHLIGHT
	if(sw) {
		paper_highlight(sw, 0);
		/*printf("erase HL from %s (%o)\n", myname(sw), sw);*/
	}
#endif
	sw_previous = sw;
	c_window = XtWindow(w);
	sw	 = (PaperWidget)w;
	c_gc     = paper_gc(sw);
	find_font(c_gc);
	p_init	 = 1;

#ifdef HIGHLIGHT
	paper_highlight(sw, 1);
	/*printf("\t\tassign HL to %s (%o)\n", myname(sw), sw);*/
#endif
}

/* Untested */
#ifdef NEW_C
void set_default_args(Display *d, Window   w, GC  g)
#else
void set_default_args(d, w, g)
	Display *d;
	Window   w;
	GC	 g;
#endif
{
	Dpy	  = d;
	c_window  = w;
	c_gc	  = g;
	find_font(c_gc);
	p_init    = 1;
	sw        = 0;	/* no draw_area widget */
}

#ifdef NEW_C
int get_default_args(Display **d, Window   *w, GC  *g)
#else
int get_default_args(d, w, g)
	Display **d;
	Window   *w;
	GC	 *g;
#endif
{
	if(!p_init) return(0);
	*d = Dpy;
	*w = c_window;
	*g = c_gc;
	return(1);
}

#ifdef NEW_C
void background_widget(Widget w)
#else
void background_widget(w)
	Widget w;
#endif
{
	if(confirm_paper_class(w) != True) return;

	b_widget = (PaperWidget)w;
}

#ifdef USE_OK
#ifdef NEW_C
int default_dest_OK()
#else
int default_dest_OK()
#endif
{
	if(sw==b_widget) return(1);
	else return(0);
}
#endif

#ifdef NEW_C
void grab_draw_area()
#else
void grab_draw_area()
#endif
{
	c_window = XtWindow((Widget)b_widget);
	c_gc	 = paper_gc(b_widget);
}

#ifdef NEW_C
void release_draw_area()
#else
void release_draw_area()
#endif
{
	c_window = XtWindow((Widget)sw);
	c_gc	 = paper_gc(sw);
}

#ifdef NEW_C
void restore_destination()
#else
void restore_destination()
#endif
{
	draw_area((Widget)sw_previous);
}

static XFontStruct *font_info;		/* extracted from c_gc */
/* Called by draw_area */
#ifdef NEW_C
static void find_font(GC gc)
#else
static void find_font(gc)
	GC gc;
#endif
{
	XGCValues v;
	XFontStruct *font_info_t;

	font_info_t = XQueryFont( Dpy, (GContext)XGContextFromGC(c_gc) );
	if(!font_info_t) select_font("fixed");
	else  font_info = font_info_t;
}

#ifdef NEW_C
int select_font(char *s)
#else
int select_font(s)
	char *s;
#endif
{
	XFontStruct *font_info_t;

	if(!d_init) own_error(1,"No server connection");

	font_info_t = XLoadQueryFont(Dpy, s);
	if(font_info_t) {
		font_info = font_info_t;
		XSetFont(Dpy, c_gc, font_info->fid);
		return(1);
	}
	else {
		own_error(0, s);
		own_error(0,"Font not found");
		return(0);
	}
}

#ifdef NEW_C
int get_font_height()
#else
int get_font_height()
#endif
{
	if(font_info) return(font_info->ascent + font_info->descent);
	else return(20);
}

#ifdef NEW_C
int fontlength(char *s)
#else
int fontlength(s)
	char *s;
#endif
{
	if(font_info) return( XTextWidth(font_info, s, strlen(s)) );
	else return( strlen(s)*12);
}

#ifdef NEW_C
void clear_screen(int x, int y, int W, int H)
#else
void clear_screen(x, y, W, H)
#endif
{
	if(!p_init) return;

	if(x<0 || y<0 || W<1 || H<1) {
		XClearWindow(Dpy, c_window);
		paper_highlight(sw, 1);
	}
	else XClearArea(Dpy, c_window, x, y, W, H, False);
}

#ifdef NEW_C
void make_dash()
#else
void make_dash()
#endif
{
	if(!p_init) return;
#ifdef OLD_WAY
	XGetGCValues(Dpy, c_gc, GCLineStyle | GCLineWidth, &vv);

	XSetLineAttributes(Dpy, c_gc, vv.line_width, LineOnOffDash,
		CapButt, JoinMiter);
#else
	vv.line_style = LineOnOffDash;
	XChangeGC(Dpy, c_gc,  GCLineStyle, &vv);
#endif
}

#ifdef NEW_C
void make_solid()
#else
void make_solid()
#endif
{
	if(!p_init) return;
#ifdef OLD_WAY
	XGetGCValues(Dpy, c_gc, GCLineStyle | GCLineWidth, &vv);

	XSetLineAttributes(Dpy, c_gc, vv.line_width, LineSolid,
		CapButt, JoinMiter);
#else
	vv.line_style = LineSolid;
	XChangeGC(Dpy, c_gc, GCLineStyle, &vv);
#endif
}

#ifdef NEW_C
void set_line_width(int n)
#else
void set_line_width(n)
#endif
{
	if(!p_init) return;
#ifdef OLD_WAY
	XGetGCValues(Dpy, c_gc, GCLineStyle | GCLineWidth, &vv);
	XSetLineAttributes(Dpy, c_gc, n, vv.line_style,
		CapButt, JoinMiter);
#else
	vv.line_width = n;
	XChangeGC(Dpy, c_gc, GCLineWidth, &vv);
#endif
}

/*	Modes - Foreground - Background		*/

#ifdef NEW_C
void use_xor_mode()
#else
void use_xor_mode()
#endif
{
	static need_warning = 1;

	if(!p_init) return;

	XGetGCValues(Dpy, c_gc, GCForeground | GCBackground | GCFunction, &vv);
	if(vv.function==GXxor) return;

	if(vv.background && need_warning) {
		own_error(0,
			"Warning: XOR may not work with nonzero background");
		need_warning = 0;
	}
	XSetFunction(Dpy, c_gc, GXxor);
}

#ifdef NEW_C
void use_replace_mode()
#else
void use_replace_mode()
#endif
{
	if(!p_init) return;

	XSetFunction(Dpy, c_gc, GXcopy);
}

static int old_foregr;

#ifdef NEW_C
void erase()
#else
void erase()
#endif
{
	XGetGCValues(Dpy, c_gc, GCForeground | GCBackground, &vv);
	old_foregr = vv.foreground;
	XSetForeground(Dpy, c_gc, vv.background);
}

#ifdef NEW_C
void resume()
#else
void resume()
#endif
{
	XSetForeground(Dpy, c_gc, old_foregr);
}

#ifdef NEW_C
void xor_fore()
#else
void xor_fore()
#endif
{
	if(!p_init) return;

	XGetGCValues(Dpy, c_gc, GCForeground | GCBackground | GCFunction, &vv);
	if(vv.function != GXxor || !vv.background) return;

	XSetForeground(Dpy, c_gc, vv.foreground^vv.background);
}

#ifdef NEW_C
void set_foregr(unsigned long c)
#else
void set_foregr(c)
	unsigned long c;
#endif
{
	if(!p_init) return;

	XSetForeground(Dpy, c_gc, c);
}

#ifdef NEW_C
void set_backgr(unsigned long c)
#else
void set_backgr(c)
	unsigned long c;
#endif
{
	if(!p_init) return;

	XSetBackground(Dpy, c_gc, c);
}

/*	Higher Level Fore- and Back- grounds	*/

#ifdef NEW_C
int fore_color(char *cname)
#else
int fore_color(cname)
	char *cname;
#endif
{
	long c = add_named_color(cname);
	if(c>=0) set_foregr(c);
	else return(-1);
	return(0);
}

#ifdef NEW_C
int back_color(char *cname)
#else
int back_color(cname)
	char *cname;
#endif
{
	long c = add_named_color(cname);
	if(c>=0) set_backgr(c);
	else return(-1);
	return(0);
}

/*	Drawing Functions	*/

#ifdef NEW_C
void put_line(int x1, int y1, int x2, int y2)
#else
void put_line(x1, y1, x2, y2)
#endif
{
	if(!p_init) return;

	XDrawLine(Dpy, c_window, c_gc, x1, y1, x2, y2);
}

#ifdef NEW_C
void put_poly(XPoint v[], int n)
#else
void put_poly(v, n)
	XPoint v[];
#endif
{
	XGCValues values;
	Pixmap	board;
	GC	gc_tmp;

	register i;
	int xmin, ymin, xmax, ymax;
	int width, height, depth;

	if(!p_init) return;

	xmin = xmax = v[0].x;
	ymin = ymax = v[0].y;
	for(i=0; i<n; i++) {
		if(v[i].x < xmin) xmin = v[i].x;
		else if(v[i].x > xmax) xmax = v[i].x;
		if(v[i].y < ymin) ymin = v[i].y;
		else if(v[i].y > ymax) ymax = v[i].y;
	}
	width  = xmax - xmin + 1;
	height = ymax - ymin + 1;
	depth = DefaultDepth(Dpy, DefaultScreen ( Dpy ) );

	board = XCreatePixmap(Dpy, c_window, width, height, depth);

	gc_tmp = XCreateGC(Dpy, board, 0, &values);
	XCopyGC(Dpy, c_gc, 0x1FFFF, gc_tmp);
	XSetFunction(Dpy, gc_tmp, GXclear);
	XFillRectangle(Dpy, board, gc_tmp, 0, 0, width, height);
	XSetFunction(Dpy, gc_tmp, GXcopy);

	for(i=0; i<n; i++) {
		v[i].x -= xmin;	v[i].y -= ymin;
	}
	XDrawLines(Dpy, board, gc_tmp, v, n, CoordModeOrigin);
	XCopyArea(Dpy, board, c_window, c_gc, 0, 0, width, height, xmin, ymin);
	XFreePixmap(Dpy, board);
	/* restore values */
	for(i=0; i<n; i++) {
		v[i].x += xmin;	v[i].y += ymin;
	}
}

#ifdef NEW_C
void put_rectangle(int x, int y, int w, int h)
#else
void put_rectangle(x, y, w, h)
#endif
{
	if(!p_init) return;

	XDrawRectangle(Dpy, c_window, c_gc, x, y, w, h);
}

#ifdef NEW_C
void fill_rectangle(int x, int y, int w, int h)
#else
void fill_rectangle(x, y, w, h)
#endif
{
	int no_color = -1;

	if(!p_init) return;

	if(w<1 || h<1) return;
	XFillRectangle(Dpy, c_window, c_gc, x, y, w, h);
}

#ifdef NEW_C
int put_text(char *text, int x, int y)
#else
int put_text(text, x, y)
	char *text;
#endif
{
	int n;

	if(!p_init) return;

	n = strlen(text);
	XDrawString(Dpy, c_window, c_gc, x, y, text, n );
	return(fontlength(text) );
}

#ifdef NEW_C
void put_arc(int cx, int cy, int rx, int ry, int start_a, int length_a)
#else
void put_arc(cx, cy, rx, ry, start_a, length_a)
#endif
{
	int x, y, w, h;

	if(!p_init) return;

	x = cx - rx;
	y = cy - ry;
	w = rx + rx;
	h = ry + ry;
	start_a *= 64;
	length_a *= 64;

	XDrawArc(Dpy, c_window, c_gc, x, y, w, h, start_a, length_a);
}

typedef struct Point {
	short x, y;
	} Point;

#ifdef NEW_C
void poly_fill(Point v[], int n, char rule)
#else
void poly_fill(v, n, rule)
	Point v[];
	char rule;
#endif
{

	if(!p_init) return;

	if(rule=='w') XSetFillRule(Dpy, c_gc, WindingRule);
	else XSetFillRule(Dpy, c_gc, EvenOddRule);
	XDrawLines(Dpy, c_window, c_gc, (XPoint *)v, n, CoordModeOrigin);
	XFillPolygon(Dpy, c_window, c_gc, (XPoint *)v, n, Complex,
		CoordModeOrigin);
}

static Region pr;

#ifdef NEW_C
void poly_clip(Point v[], int n, char rule)
#else
void poly_clip(v, n, rule)
	Point v[];
	char rule;
#endif
{
	int k;

	if(!p_init) return;

	if(!n) {
		XSetClipMask(Dpy, c_gc, vv.clip_mask);
	}
	else {
		XGetGCValues(Dpy, c_gc, GCClipMask, &vv);

		if(rule=='w') k = WindingRule;
		else k = EvenOddRule;

		pr = XPolygonRegion((XPoint *)v, n, k);
		XSetRegion(Dpy, c_gc, pr);
	}
}

#ifdef NEW_C
void set_fill_style(char *s)
#else
void set_fill_style(s)
	char *s;
#endif
{
	if(!p_init) return;

	switch(s[0]){
	case 's':
	case 'S':
		switch(s[1]) {
		case 'o': XSetFillStyle(Dpy, c_gc, FillSolid); return;
		case 't': XSetFillStyle(Dpy, c_gc, FillStippled); return;
		default:  break;
		}
		return;
	case 't':
	case 'T': XSetFillStyle(Dpy, c_gc, FillTiled); return;
	}
	/*own_error(0,"Unknown fill style");*/
}

static Pixmap px;

#ifdef NEW_C
void tile_backgound(int n)
#else
void tile_backgound(n)
#endif
{
	register i;
	unsigned char v[256];
	XImage *xi;

	if(!p_init) return;

	for(i=0; i<256; i++) v[i] = n;
	xi = XCreateImage(Dpy, DefaultVisual(Dpy, DefaultScreen(Dpy)),
		8 /*bits/pel*/, ZPixmap, 0, v, 16, 16, 8, 0);
	px = XCreatePixmap(Dpy, c_window, 16, 16, 8);
	
	XSetFunction(Dpy, c_gc, GXcopy);
	XPutImage(Dpy, px, c_gc, xi, 0, 0, 0, 0, 16, 16);
	XSetTile(Dpy, c_gc, px);
	XSetFillStyle(Dpy, c_gc, FillTiled);
	XSetFunction(Dpy, c_gc, GXxor);
}

#ifdef NEW_C
void fill_solid(int n)
#else
void fill_solid(n)
#endif
{
	if(!p_init) return;

	XSetFillStyle(Dpy, c_gc, FillSolid);
	XSetForeground(Dpy, c_gc, n);
}

extern XImage *icon_image();

#define SERVER_STORE

#ifdef NEW_C
void put_image(pImage *img, int x, int y)
#else
void put_image(img, x, y)
	pImage *img;
#endif
{
	Pixmap px = (Pixmap)img->ID;

	if(!p_init) return;

	if(!img->ID) return;

#ifdef SERVER_STORE
	if(no_depth()) XCopyPlane(Dpy, px, c_window, c_gc, 0, 0,
		img->width, img->height, x, y, 1);
	else XCopyArea(Dpy, px, c_window, c_gc, 0, 0,
		img->width, img->height, x, y);
#else
	if(img->depth>1)	/* see p_fullpix.c for reason */
		XPutImage(Dpy, c_window, c_gc, (XImage *)img->ID,
			0, 0, x, y, img->width, img->height);
#endif
	return;
}

#ifdef NEW_C
void put_icon_im(char *cv, int w, int h, int x, int y)
#else
void put_icon_im(cv, w, h, x, y)
	char *cv;
#endif
{
	XImage *xi = icon_image(cv, w, h);

	if(!p_init) return;

	XPutImage(Dpy, c_window, c_gc, xi, 0, 0, x, y, w, h);
	XFree((caddr_t)xi);      
}

/*	Icon and Cursor Utilities		*/
/*	Iconss		*/
#define NICON	 256	/* Max. number of icons and/or cursors used by a pgm */
#define BL	 512	/* Max. icon vector size 64*64/8 */
typedef struct Icon_set {
	Pixmap pixels;
	int w;		/* width */
	int h;		/* height */
	int cx, cy;	/* center */
} Icon_set;
static Icon_set u_icon[NICON];
static int n_icon = 0;

#ifdef NEW_C
int make_icon(char iconbits[], int w, int h, int cx, int cy)
#else
int make_icon(iconbits, w, h, cx, cy)
	char iconbits[];
#endif
{
	if(!p_init) return;

	if(n_icon>(NICON-1)) return(-1);

	u_icon[n_icon].pixels = 
		XCreateBitmapFromData(Dpy, c_window, iconbits, w, h);
	u_icon[n_icon].w = w;
	u_icon[n_icon].h = h;
	u_icon[n_icon].cx = cx;
	u_icon[n_icon].cy = cy;
	n_icon++;
	return(n_icon-1);
}

#ifdef NEW_C
draw_icon(int k, int x, int y)
#else
draw_icon(k, x, y)
#endif
{
	if(!p_init) return;

	if(k<0 || k>=NICON) return;

	XCopyPlane(Dpy, u_icon[k].pixels, c_window, c_gc, 0, 0,
		u_icon[k].w, u_icon[k].h, x-u_icon[k].cx, y-u_icon[k].cy, 1);
}

static Cursor u_cursor[NICON];
static int n_cursor;
static Pixmap Cursor_icon;
static Pixmap Cursor_mask;

#ifdef NEW_C
int make_cursor(unsigned char iconbits[], int hx, int hy)
#else
int make_cursor(iconbits, hx, hy)
	unsigned char iconbits[];
#endif
{
	return make_color_cursor(iconbits, hx, hy, "black", "white");
}

#ifdef NEW_C
int make_color_cursor(unsigned char iconbits[], int hx, int hy,
	char *color, char *mask_color)
#else
int make_color_cursor(iconbits, hx, hy, color, mask_color)
	unsigned char iconbits[];
	char *color, *mask_color;
#endif
{
	XColor Ccursor, Cmask;
	unsigned char maskbits[BL];
	int default_cursor_color = 0, defaul_mask_color = 0177777;

	if(!p_init) return;

	if(n_cursor > NICON-1) return(-1);

	make_cursor_mask(iconbits, maskbits);

	Cursor_icon = XCreateBitmapFromData(Dpy, c_window, iconbits, 16, 16);

	Cursor_mask = XCreateBitmapFromData(Dpy, c_window, maskbits, 16, 16);

	get_color_cell( &Ccursor, color, default_cursor_color);
	get_color_cell( &Cmask, mask_color, defaul_mask_color);

	u_cursor[n_cursor++] = XCreatePixmapCursor(Dpy,
		Cursor_icon, Cursor_mask, &Ccursor, &Cmask, hx, hy);

	return(n_cursor-1);
}

#ifdef NEW_C
void active_cursor(int n)
#else
void active_cursor(n)
#endif
{
	if(!p_init) return;

	if(n<0 || n>=NICON) XDefineCursor(Dpy, c_window, None);
	else XDefineCursor(Dpy, c_window, u_cursor[n]);
}

#ifdef NEW_C
Cursor true_cursor(int n)
#else
Cursor true_cursor(n)
#endif
{
	if(!p_init) return;

	if(n<0 || n>=NICON) return None;
	else  return u_cursor[n];
}

#ifdef NEW_C
void make_stiple(int k)
#else
void make_stiple(k)
#endif
{
	if(!p_init) return;

	if(k<0 || k>=NICON) return;

	XSetStipple(Dpy, c_gc, u_icon[k].pixels);
}

/*	Selection Utilities	*/
#include <X11/Xatom.h>
static void (*use)();
#ifdef NEW_C
static void gen_use_selection(Widget w, XtPointer client_data,
	Atom *selection, Atom *type,
	XtPointer value,
	unsigned long *length, int *format)
#else
static void gen_use_selection(w, client_data, selection,
						type, value, length, format)
	Widget w;
	XtPointer client_data;
	Atom *selection, *type;
	XtPointer value;
	unsigned long *length;
	int	*format;
#endif
{
	if(confirm_paper_class(w) != True) return;
	if(!use) return;
	if(*selection==XA_PRIMARY && *type==XA_STRING && *format==8
	   && value != NULL && *length>0) use((char *)value);
	else use("");
}

/*	Ask the server for the selection for the draw_area widget
	and have f() process it
*/
#ifdef NEW_C
void get_selection(void (*f)())
#else
void get_selection(f)
	void (*f)();
#endif
{
	if(!p_init) return;

	use    = f;
 
	XtGetSelectionValue( (Widget)sw, XA_PRIMARY, XA_STRING,
		gen_use_selection, (XtPointer) NULL,
		XtLastTimestampProcessed(XtDisplay((Widget)sw)) );
}

/*	Ask the server to make this a selection		*/
/* invoked by application that picked x, y, s */
extern void text_size(), mark_selection();

/*	called by Intrinsics when someone asks for the selection	*/
Boolean pDeliverSelection(w, selection, target, type_r, value_r,
						length_r, format_r)
	Widget w;
	Atom *selection, *target, *type_r;
	XtPointer *value_r;
	unsigned long *length_r;
	int *format_r;
{
	PaperWidget	sw = (PaperWidget)w;
	static Atom	targets = 0;

	if(targets==0)
		targets = XInternAtom(XtDisplay(w), "TARGETS", False);

	printf("Conversion called [s=%d t=%d]\n", *selection, *target);

	if(*target==targets) {
		*type_r = XA_ATOM;
		*value_r = (XtPointer) XtNew(Atom);
		*(Atom *) *value_r = XA_STRING;
		*length_r = 1;
		*format_r = 32;
		printf("Taking atom ... [%d]\n", *value_r);
		return(TRUE);
	}

	if(*target==XA_STRING) {
		*type_r   = XA_STRING;
		*value_r  = XtNewString(label);
		*length_r = label_len;
		*format_r = 8;
		printf("Taking string ... [%s]\n", *value_r);
		return(TRUE);
	}
	return(FALSE);
}

void pLoseSelection(w, selection)
	Widget w;
	Atom *selection;
{
	if(confirm_paper_class(w) != True) return;
	mark_selection(w);
	has_selection = FALSE;
}


#ifdef NEW_C
int own_selection(int x, int y, char *s)
#else
int own_selection(x, y, s)
char *s;
#endif
{
	if(!p_init) return;

	/* sw is static draw_area widget */

	if(has_selection) {
		XtDisownSelection((Widget)sw, XA_PRIMARY,
			XtLastTimestampProcessed(XtDisplay(sw)));
		printf("Giving up selection\n");
		/* return TRUE; */
	}

	label_x = x;
	label_y = y;
	label_len = strlen(s);
	label = XtNewString(s);
	text_size(s, &label_width, &label_height);
	selection_w  = sw;

	has_selection = XtOwnSelection((Widget)sw, XA_PRIMARY,
					XtLastTimestampProcessed(XtDisplay(sw)),
					pDeliverSelection, pLoseSelection, NULL);

	if(has_selection) {
		mark_selection(sw);
	}
	return has_selection;
}

#ifdef NEW_C
void text_size(char *s, Dimension *wp, Dimension *hp)
#else
void text_size(s, wp, hp)
	char *s; Dimension *wp, *hp;
#endif
{
	char *cp0, *cp1;
	Dimension tmpw;

	cp0 = s;	*wp = *hp = 0;
	while(	cp1 = (char *)strchr(cp0,'\n') ){
		*cp1 = '\0';
		tmpw = fontlength(cp0);	if(tmpw > *wp) *wp = tmpw;
		*cp1 = '\n';
		cp0 = cp1+1;	*hp += get_font_height();
		if( !(*cp0) ) return;
	}
	tmpw = fontlength(cp0);	if(tmpw > *wp) *wp = tmpw;
	*hp += get_font_height();
}

#ifdef NEW_C
void deliver_selection(String *sp, int *np)
#else
void deliver_selection(sp, np)
	String *sp;
	int *np;
#endif
{
	*np = label_len;
	*sp = XtNewString(label);
}

/*
	The code below assumes selection was placed in a particular spot
	and that XOR is used.
*/
#ifdef NEW_C
void give_up_selection(Widget w)
#else
void give_up_selection(w)
	Widget w;
#endif
{
	if(confirm_paper_class(w) != True) return;
	mark_selection(w);	/* should be in callback list */
	has_selection = FALSE;
}

#ifdef NEW_C
void mark_selection(Widget w)
#else
void mark_selection(w)
	Widget w;
#endif
{
	PaperWidget tsw = (PaperWidget)w;

	if(confirm_paper_class(w) != True) return;
	XSetFunction(Dpy, pr_paper_gc(tsw), GXxor);

	XFillRectangle(
		XtDisplay((Widget)tsw), XtWindow((Widget)tsw),
		pr_paper_gc(tsw),
		label_x - space,
		label_y - label_height - space/2, /* should use font ascender */
		label_width + space*2, label_height + space*2);

	XSetFunction(Dpy, pr_paper_gc(tsw), GXcopy);
}

#ifdef NEW_C
void mark_draw_area_selection()
#else
void mark_draw_area_selection()
#endif
{
	if(has_selection) mark_selection((Widget)sw);
}

/*	Even Handlers and Redraw Functions	*/

#ifdef NEW_C
void set_handler(void (*g)())
#else
void set_handler(g)
	void (*g)();
#endif
{
	if(!p_init) return;

	w_set_handler(sw, g);
}

#ifdef NEW_C
void reset_handler()
#else
void reset_handler()
#endif
{
	if(!p_init) return;

	w_set_handler(sw, 0);
}

#ifdef NEW_C
void set_redraw(void (*f)())
#else
void set_redraw(f)
	void (*f)();
#endif
{
	if(!p_init) return;

	if(f) w_set_redraw(sw, f);
}

#ifdef NEW_C
void window_dim(int *wp, int *hp)
#else
void window_dim(wp, hp)
	int *wp, *hp;
#endif
{

	if(!p_init) return;

	w_window_dim(sw, wp, hp);
}

/*	old x_translate.c file	*/
/*	Main link between X events and naive user events	*/

#define KEY_BUF_SZ	256

static int debug = 0;

#ifdef NEW_C
translate_events(XEvent *ep, pEvent *p)
#else
translate_events(ep, p)
	XEvent *ep;
	pEvent *p;
#endif
{
	static char buffer[KEY_BUF_SZ];
	KeySym keysym;
	XComposeStatus compose;
	int nc;
	
	p->kind = NULL;
	switch(ep->type) {
	case MotionNotify:
		switch(ep->xmotion.state){
		case 0:		  p->kind = MOVE; p->key = NULL;   break;
		case Button1Mask: p->kind = DRAG; p->key = LEFT;   break;
		case Button2Mask: p->kind = DRAG; p->key = MIDDLE; break;
		case Button3Mask: p->kind = DRAG; p->key = RIGHT;  break;
		default: p->kind = NULL;
		}
		p->x =  (ep->xmotion).x;
		p->y =  (ep->xmotion).y;
		return;
	case ButtonRelease:
		p->kind = BTN_RELEASE;
		switch((ep->xbutton).button) {
		case 1:	p->key = LEFT;	 break;
		case 2:	p->key = MIDDLE; break;
		case 3: p->key = RIGHT;	 break;
		}
		p->x =  (ep->xbutton).x;
		p->y =  (ep->xbutton).y;
		return;
	case ButtonPress:
		p->kind = BTN_PRESS;
		switch((ep->xbutton).button) {
		case 1:	p->key = LEFT;	 break;
		case 2:	p->key = MIDDLE; break;
		case 3: p->key = RIGHT;	 break;
		}
		p->x =  (ep->xbutton).x;
		p->y =  (ep->xbutton).y;
		return;
	case KeyPress:
		p->x =  (ep->xkey).x;
		p->y =  (ep->xkey).y;
		nc = XLookupString((XKeyEvent *)ep, buffer, sizeof(buffer),
			&keysym, &compose);
		if(nc) {
			switch(buffer[0]){
			case '\n':
			case '\r':	p->kind = KEY_RETURN;
					p->key	= NULL;
				if(debug) printf("Return\n");
				return;
			case 127: /*DEL*/
			case 8: /*BS*/	p->kind = KEY_ERASE;
					p->key	= NULL;
				if(debug) printf("Delete\n");
				return;
			case 033: /*ESC*/ p->kind = ESCAPE;
					  p->key  = NULL;
				if(debug) printf("Escape\n");
				return;
			default: if(' '<=buffer[0]&& buffer[0] <='~'  ) {
					/* 32 to 126 */
					p->kind = KEY_NORMAL;
					p->key = buffer[0];
					if(debug) printf("Normal: %s\n",buffer);
				}
				return;
			}
		}
	}
}
