/***********************************************************
Copyright 1995 by Theo Pavlidis (except as noted)

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
/*	Image Processing Facilities	*/


/****************** START OF rasterfile.h ********************************/
/*
	This part of the code is a copy of /usr/include/rasterfile.h which
has been produced by Sun Microsystem and its ownership is covered by
different rules than the ones stated above. If you run on a SUN system,
you should replace it by the statement
#include <rasterfile.h>
*/

struct rasterfile {
	int	ras_magic;		/* magic number */
	int	ras_width;		/* width (pixels) of image */
	int	ras_height;		/* height (pixels) of image */
	int	ras_depth;		/* depth (1, 8, or 24 bits) of pixel */
	int	ras_length;		/* length (bytes) of image */
	int	ras_type;		/* type of file; see RT_* below */
	int	ras_maptype;		/* type of colormap; see RMT_* below */
	int	ras_maplength;		/* length (bytes) of following map */
	/* color map follows for ras_maplength bytes, followed by image */
};
#define	RAS_MAGIC	0x59a66a95

	/* Sun supported ras_type's */
#define RT_OLD		0	/* Raw pixrect image in 68000 byte order */
#define RT_STANDARD	1	/* Raw pixrect image in 68000 byte order */
#define RT_BYTE_ENCODED	2	/* Run-length compression of bytes */
#define RT_FORMAT_RGB	3	/* XRGB or RGB instead of XBGR or BGR */
#define RT_FORMAT_TIFF	4	/* tiff <-> standard rasterfile */
#define RT_FORMAT_IFF	5	/* iff (TAAC format) <-> standard rasterfile */
#define RT_EXPERIMENTAL 0xffff	/* Reserved for testing */

	/* Sun registered ras_maptype's */
#define RMT_RAW		2
	/* Sun supported ras_maptype's */
#define RMT_NONE	0	/* ras_maplength is expected to be 0 */
#define RMT_EQUAL_RGB	1	/* red[ras_maplength/3],green[],blue[] */


/****************** END OF rasterfile.h ********************************/

#include <Starter.h>

#ifdef NEW_C
int ch_order(int *ptr)
#else
int ch_order( ptr)
	int *ptr;
#endif
{
 	*ptr = *ptr>>8 & 0x0000ff00 | *ptr>>24 & 0x000000ff 
        | *ptr<<24 | *ptr<<8 & 0x00ff0000;   
}

/*	Read Raster File - Really Independent of X but dependent on SUN	*/

#ifdef NEW_C
int read_image( char *fname, pImage *result)
#else
int read_image( fname, result)
	char *fname;
	pImage *result;
#endif
{
	int img_fdesc;
	int count;
	int img_size;
	static struct rasterfile R;
	int  *tmp;
	register j, i;
	register pPixel *row_start;

	/*	Open File	*/
	img_fdesc = open(fname,0);
	if( img_fdesc < 0 ) {
		own_error( 0, "Cannot open input file");
		own_error(0, fname);
		return(-1);
	}

	/* Read Header and Check */
	count = read(img_fdesc, &R, sizeof(struct rasterfile) );
	if(R.ras_magic != RAS_MAGIC || R.ras_type != RT_STANDARD) {
		tmp = (int *)&R;
		for (j=0;j<8;j++,tmp++) ch_order(tmp);
		if(R.ras_magic != RAS_MAGIC || R.ras_type != RT_STANDARD) {
			own_error(0,"Wrong type of file");
			return(-1);
		}
	} 
	result->width  = R.ras_width;
	result->height = R.ras_height;
	result->depth  = R.ras_depth;
	img_size = R.ras_length;
	/* Allocate Memory for Pixels */
	result->pstart = (pPixel *)malloc(img_size * sizeof(pPixel) );
	if (result->pstart == 0) {
		own_error(0, "Cannot allocate memory");
		return(-1);
	}

	/* Read Color Map if Any */
	if(R.ras_maptype && R.ras_maplength) {
		int cmlen, nn;

		printf("cmap info %o %d\n", R.ras_maptype, R.ras_maplength);
		result->cmap_len = cmlen = R.ras_maplength/3;
		nn = cmlen*3;
		if(nn != R.ras_maplength) own_error(0,"Strange cmap length");
		result->cmap_type = R.ras_maptype;
		result->red = (pPixel *)malloc(cmlen*sizeof(pPixel));
		result->green = (pPixel *)malloc(cmlen*sizeof(pPixel));
		result->blue = (pPixel *)malloc(cmlen*sizeof(pPixel));
		read( img_fdesc, result->red, cmlen);
		read( img_fdesc, result->green, cmlen);
		read( img_fdesc, result->blue, cmlen);
		if(cmlen<255) result->pixel_offset = 255 - cmlen;
		else result->pixel_offset = 0;
	}
	else {
		result->cmap_type = 0;
		result->cmap_len =  0;
		result->pixel_offset = 64;	/* for now */
	}

	/* Read Pixel values */
	switch(result->depth){
	case 1:
		count = read( img_fdesc, result->pstart, img_size);
		break;
	case 8:
		for( row_start = result->pstart, j=0;
			j < result->height;
			j++, row_start +=  result->width ) {
			count = read( img_fdesc, row_start,
					R.ras_width+R.ras_width%2 );
		}
		break;
	case 24:
		for( row_start = result->pstart, j=0;
			j < result->height;
			j++, row_start +=  3*R.ras_width ) {
			count = read( img_fdesc, row_start,
					3*R.ras_width );
		}
		break;
	default:
		own_error(0,"Irregular depth");
		return(-1);
	}
	close( img_fdesc );
	return(0);
}

/*	Write Raster File - Really Independent of X but dependent on SUN	*/

#ifdef NEW_C
int write_image( char *fname, pImage *given)
#else
int write_image( fname, given)
	char *fname;
	pImage *given;
#endif
{
	int img_fdesc;
	int count;
	static struct rasterfile R;
	register j;
	register pPixel *row_start;
	int out_width, d_width;
	pPixel border[4];

	/*	create file (use old-fashionned call for portability)	*/
	if((img_fdesc=creat(fname,0644))<0) {
		own_error(0, "Cannot create output file\n");
		return(-1);
	}

	out_width = given->width;	while(out_width%4) out_width++;
	d_width = out_width - given->width;
	if(d_width) {
		for(j=0; j<d_width; j++) border[j] = 255;
		own_error(0, "Border added to make file width multiple of 4");
	}

	R.ras_magic  = RAS_MAGIC;	/* 0x59a66a95 */
	R.ras_width  = out_width;
	R.ras_height = given->height;
	R.ras_depth  = given->depth;
	R.ras_length = out_width*given->height;
	if(given->depth==24)  R.ras_length *= 3;
	R.ras_type   = RT_STANDARD;	/* 1 */
	R.ras_maptype = given->cmap_type? RMT_EQUAL_RGB : RMT_NONE;
	R.ras_maplength = 3*given->cmap_len;

        count = write(img_fdesc, &R, sizeof(struct rasterfile) );

	/* Write Color Map if Any */
	if(R.ras_maptype && R.ras_maplength) {
		write( img_fdesc, given->red, given->cmap_len);
		write( img_fdesc, given->green, given->cmap_len);
		write( img_fdesc, given->blue, given->cmap_len);
	}

	/* Write Pixel values */
	switch(given->depth){
	case 1:
		write(img_fdesc, given->pstart, R.ras_length/8);
		break;
	case 8:
		for( row_start=given->pstart, j=0; 
			j<given->height; 
			j++, row_start += given->width ) {
				write(img_fdesc, row_start, given->width);
				if(d_width) write(img_fdesc, border, d_width);
		}
		break;
	case 24:
		for( row_start=given->pstart, j=0; 
			j<given->height; 
			j++, row_start += 3*given->width ) {
				write(img_fdesc, row_start, 3*given->width);
				if(d_width) {
					register k;
					for(k=0; k<3; k++)
					write(img_fdesc, border, d_width);
					}
			}
		break;
	default:
		own_error(0,"Irregular depth");
		return(-1);
	}
	close( img_fdesc );
	return(0);
}
