/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
/*
	Dialogue Pop-up Window - Static paper widget.
	Only one per application. It can display different
	dialogs, depending on the argument of start_dialog().
*/
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Starter.h>

extern Widget create_paper_widget();
extern int collect_text();	/* in util.c */

static void d_draw();		/* down below */
static void cont_dialog();
extern void end_dialog();

static Widget d_widget = 0;
static int d_x0=10, d_y0=20, d_w=256, d_h=128, dx_gap=5, dy_gap=24;
static int x, y;
static pAction *scenario, *scenario_start;
static int dialog_active = 0;
static char *reply[64];	/* well above maximum number expected */
static char **rp;

/* Message is not saved and does not appear in redraw */
#ifdef NEW_C
void to_dialog(char *s)
#else
void to_dialog(s)
	char *s;
#endif
{
	draw_area(d_widget);
	y += dy_gap;	x = d_x0;
	put_text( s, x, y);
}

#define CAUTION(A) if( !(A) ) { end_dialog(); return; }

#ifdef NEW_C
static void cont_dialog(char *s)
#else
static void cont_dialog(s)
	char *s;
#endif
{
	if(!dialog_active) return;
	CAUTION(scenario);
	CAUTION(scenario->label);

	scenario->fun(s);
	mk_label(rp, s);	rp++;
	if(!dialog_active) return;	/* it may have been reset by fun() */
	scenario++;
	CAUTION(scenario->label);

	draw_area(d_widget);
	y += dy_gap;	x = d_x0;
	x += put_text( scenario->label, x, y) + dx_gap;
	init_text(x, y, 1);
}

#ifdef NEW_C
void start_dialog(pAction messages[])
#else
void start_dialog(messages)
	pAction messages[];
#endif
{
	scenario = scenario_start = messages;
	rp = reply;
	dialog_active = 1;

	if(!d_widget) d_widget = create_paper_widget(d_draw, collect_text,
						d_w, d_h, 2, "Dialogue");
	popup(d_widget, 0);
	draw_area(d_widget);

	set_string_use(cont_dialog);
}

#ifdef NEW_C
void end_dialog()
#else
void end_dialog()
#endif
{
	dialog_active = 0;
	popdown(d_widget);
	default_destination();
	set_string_use((int *)0);
	while(--rp>=reply) free(*rp);
}

#ifdef NEW_C
static void d_draw()
#else
static void d_draw()
#endif
{
	register j;
	pAction *ap;
	char **cp;

	set_foregr(beige('l'));
	use_replace_mode();
	fill_rectangle(0, 0, d_w, d_h);
	set_foregr(beige('l')^01);
	use_xor_mode();

	ap = scenario_start;
	for(y=d_y0, cp=reply ; ap<=scenario; ap++, y+=dy_gap, cp++) {
		x = d_x0;
		x += put_text( ap->label, x, y) + dx_gap;
		if(cp<rp) if(*cp) put_text(*cp, x, y);
	}
	y -= dy_gap;
	init_text(x, y, 1);
}
