/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
#ifndef SELEXP_H
#define SELEXP_H

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include "Paper.h"

typedef struct {
	/* Resource fields */
	Pixel		foreground;
	
	XtCallbackList  redrawCallback;
	XtCallbackList  lose_selection;

	int		(*give_selection)();
	int		(*uhandler)();
	int		(*udraw)();

	/* Internal fields */
	GC		private_gc;
	GC		public_gc;
	Boolean		is_active;
	XtPointer	hang;
} PaperPart;

/*	Full Instance Record	*/
typedef struct _PaperRec {
	CorePart   core;
	PaperPart  paper;
} PaperRec;


typedef Boolean (*PaperSelectionProc)();	/* ?? */

typedef struct {
	PaperSelectionProc select;
	XtPointer	   extension;
} PaperClassPart;

/*	Full Class Record	*/
typedef struct _PaperClassRec {
	CoreClassPart	core_class;
	PaperClassPart	paper_class;
} PaperClassRec, *PaperWidgetClass;

extern PaperClassRec paperClassRec;

#define InheritSelectText ((PaperSelectionProc) _XtInherit)

#endif /* SELEXP_H */
