/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
/*	Slider Widget Prototype	*/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include <Starter.h>
#define H_SPAN	40

typedef struct {
	int x1;
	int pick;
	int msg;
	int fore;
	int back;
	int (*use)();
	char bf[16];
	char name[16];
	} slider_state;

extern Widget create_paper_widget();
extern slider_state  ** paper_hanger();	/* actually XtPointer */
static int xbase = 20, ybase = H_SPAN, height = 10;
static int xstep = 30, nstep =11, xright, window_width = 440;

static void mark();
void slider(), color_slider();

#ifdef NEW_C
static void handler(pEvent *p)
#else
static void handler(p)
	pEvent *p;
#endif
{
	Widget w;
	double xresult;
	slider_state *sp;

	w = (Widget)p->origin;
	sp = *paper_hanger( w );

	switch(p->kind+p->key) {
	case LEFT_RELEASE:
		if(sp->pick) {
			if(sp->msg) put_text(sp->bf, 20, ybase-20);
			sprintf(sp->bf, "%5.2f",
				xresult = 10*(double)(sp->x1-xbase)/xstep );
			put_text(sp->bf, 20, ybase-20);	sp->msg = 1;
			sp->pick = 0;
			if(sp->use) sp->use(xresult);
		}
		break;
	case LEFT_PRESS:
	case LEFT_DRAG:
		if(p->x < xbase || p->x > xright
		|| p->y < height || p->y > ybase + 2*height) return;
		if(!sp->pick) {
			if(p->y > ybase - 2*height
			&& p->y < ybase + height
			&& p->x > sp->x1-4 && p->x < sp->x1+4) sp->pick = 1;
			return;
		}
		else {
			mark(sp->x1);	sp->x1 = p->x;	mark(sp->x1);
		}
		break;
	}
}

#ifdef NEW_C
static void draw_f(Widget wg)
#else
static void draw_f(wg)
	Widget wg;
#endif
{
	register i, xx;
	static char rbf[32];
	slider_state *sp;

	sp =  *paper_hanger(wg);

	if(there_is_depth()) {
		if(sp->back) {
			use_replace_mode();
			set_foregr(sp->back);
			fill_rectangle(0, 0, window_width, H_SPAN*2);
		}
		set_foregr(sp->fore);
		set_backgr(sp->back);
	}
	use_xor_mode();

	put_rectangle(xbase, ybase-height, xstep*(nstep-1), height);
	xright = xstep*nstep;
	for(i=0; i<nstep; i++) {
		xx = xbase + i*xstep;
		put_line(xx, ybase+8, xx, ybase+18);
		sprintf(rbf,"%d", 10*i);
		put_text( rbf, i<10? xx-2: xx-6, ybase+32);
	}
	mark(sp->x1 = sp->x1? sp->x1: xbase+8);
	if(sp->msg) put_text(sp->bf, 20, ybase-20);
	put_text(sp->name, window_width-80, ybase-20);
	default_destination();
}

#ifdef NEW_C
static void mark(int x)
#else
static void mark(x)
#endif
{
	set_line_width(4);
	put_rectangle(x-4, ybase-height-4, 8, height+8);
	set_line_width(1);
	put_line(x-6, ybase-height, x+6, ybase-height);
	put_line(x-6, ybase, x+6, ybase);
	fill_rectangle(xbase, ybase-height+2, x-xbase-6, height-3);
}

#ifdef NEW_C
void slider(int (*usage)(double), char *label)
#else
void slider(usage, label)
	int (*usage)();
	char *label;
#endif
{
	color_slider(usage, label, "black", "white");
}

#ifdef NEW_C
void color_slider(int (*usage)(double), char *label, char *fore, char *back)
#else
void color_slider(usage, label, fore, back)
	int (*usage)();
	char *label, *fore, *back;
#endif
{
	Widget sl_widget = 0;
	slider_state *slp;

	sl_widget = create_paper_widget(draw_f, handler,
					window_width, H_SPAN*2, 0, label);
	*paper_hanger(sl_widget) = slp =
			(slider_state *)malloc(sizeof(slider_state));
	slp->use = usage;
	slp->msg = slp->pick = slp->x1 = 0;
	if(strlen(label)>15) label[15] = NULL;
	strcpy(slp->name, label);

	if(there_is_depth()){
		slp->fore = add_named_color(fore);
		slp->back = add_named_color(back);
		if(slp->back) slp->fore ^= slp->back;
	}
}
