/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
/*	Image Processing Widget Prototype	*/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Paper.h>

#include <Starter.h>

typedef struct {
	pImage Im;
	pImage iIm;
	char *fname;
	} pixwin_state;

extern Widget create_paper_widget();
extern Widget img_window();
extern pixwin_state  ** paper_hanger();	/* actually XtPointer */

void imgwin(), copy_image(), copy_cmap_info();

#ifdef NEW_C
int pixwin(char *fname, int (*handler)())
#else
int pixwin(fname, handler)
	char *fname;
	int (*handler)();
#endif
{
	pImage Imp;

	if( read_image( fname, &Imp ) ) {
		 own_error(0, "Cannot Read Image");
		 return(-1);
	}
	if(Imp.depth==24) compose_color(&Imp, 0);
	imgwin(fname, handler, &Imp);
	return(0);
}

#ifdef NEW_C
Widget img_widget(char *fname, void (*handler)(), pImage *img)
#else
Widget img_widget(fname, handler, img)
	char *fname;
	void (*handler)();
	pImage *img;
#endif
{
	Widget pix_widget = 0;
	pixwin_state *pwp = (pixwin_state *)malloc(sizeof(pixwin_state));
	pImage *Imp;
	static char wname[32];

	strncpy(wname, fname, 32);
	wname[31] = '\0';

	mk_label(&(pwp->fname), wname);
	copy_image(img, &(pwp->Im));
	copy_image(img, &(pwp->iIm));
	Imp = &(pwp->Im);

	pix_widget = img_window(Imp, handler, wname);

	if(Imp->depth>1) {
		int add_on;

		if(!Imp->cmap_type) prepare_gray(Imp);
		else {
			if(is_gray(Imp)) prepare_gray(Imp);
		}
		/* try to add colors in existin map - otherwise create a new one */
		add_on =
			add_RGB_colors(Imp->red, Imp->green, Imp->blue, Imp->cmap_len);
		if(!add_on) make_special_map(pix_widget, Imp);
		else Imp->pixel_offset = add_on;
	}

	setup_image(Imp);	/* last thing, after cmaps */

	*paper_hanger(pix_widget) = pwp;
	popup(pix_widget, 1);

	if(there_is_depth()) Tp_image_tile(pix_widget, Imp);
	return pix_widget;
}

#ifdef NEW_C
void imgwin(char *fname, void (*handler)(), pImage *img)
#else
void imgwin(fname, handler, img)
	char *fname;
	void (*handler)();
	pImage *img;
#endif
{
	img_widget(fname, handler, img);
}

#ifdef NEW_C
char * get_pix_name(pEvent *p)
#else
char * get_pix_name(p)
	pEvent *p;
#endif
{
	PaperWidget w;
	pixwin_state *pwp;

	w = (PaperWidget)p->origin;
	pwp = *paper_hanger( w );

	return pwp->fname;
}

#ifdef NEW_C
pImage * get_image(pEvent *p)
#else
pImage * get_image(p)
	pEvent *p;
#endif
{
	PaperWidget w;
	pixwin_state *pwp;

	w = (PaperWidget)p->origin;
	pwp = *paper_hanger( w );

#ifdef OLD_USAGE
	return &(pwp->Im);
#else
	return &(pwp->iIm);
#endif
}

#ifdef NEW_C
void copy_image(pImage  *orig_img, pImage  *copy_img)
#else
void copy_image(orig_img, copy_img)
	pImage  *orig_img;
	pImage  *copy_img;
#endif
{
	register i,  j;
	register pPixel * cp, *dp;

	copy_img->width = orig_img->width;
	copy_img->height = orig_img->height;
	copy_img->depth = orig_img->depth;
	copy_img->pstart = (pPixel *)malloc(
		copy_img->width*copy_img->height*sizeof(pPixel));
	if(!copy_img->pstart) own_error(1,"No memory");

	for(j=0, cp=orig_img->pstart, dp=copy_img->pstart;
		j<orig_img->height; j++)
		for(i=0; i<orig_img->width; i++) *dp++ = *cp++;
	copy_cmap_info(orig_img, copy_img);
}

#ifdef NEW_C
void copy_cmap_info(pImage  *orig_img, pImage  *copy_img)
#else
void copy_cmap_info(orig_img, copy_img)
	pImage  *orig_img;
	pImage  *copy_img;
#endif
{
	copy_img->cmap_type = orig_img->cmap_type;
	copy_img->cmap_len  = orig_img->cmap_len;
	copy_img->pixel_offset   = orig_img->pixel_offset;
	copy_img->red   = orig_img->red;	/* risky */
	copy_img->green = orig_img->green;
	copy_img->blue  = orig_img->blue;
}
