/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
/*	Utility Functions not dependant on Xlib	or the X Toolkit	*/

#include <stdio.h>
#include <string.h>
#include <Starter.h>

extern void make_bit_matrix(), make_char_vector(), makedither();

#ifdef NEW_C
void own_error(int serious, char *msg)
#else
void own_error(serious, msg)
	char *msg;
#endif
{
	fprintf(stderr,"%s: %s\n", "Starter Toolkit", msg);
	if(serious) exit(1);
}

/* replaces usleep for portability to System V */
#ifdef NEW_C
void idle(long n)
#else
void idle(n)
	long n;
#endif
{
	register i;
	i = n*10;
	while(i--) {}
}

#ifdef NEW_C
void mk_label(char **target, char *source)
#else
void mk_label(target, source)
	char **target, *source;
#endif
{
	*target = (char *)malloc( (strlen(source)+1)*sizeof(char) );
	if(!*target) own_error(1,"No memory");
	strcpy(*target, source);
}

/*	Read a char string from the screen	*/
static int x0, x1, y0, y1;

#ifdef NEW_C
void last_string(int *xp, int *yp)
#else
last_string(xp, yp)
	int *xp, *yp;
#endif
{
	*xp = x0;	*yp = y0;
}

static void (*use)();

#ifdef NEW_C
void set_string_use(void (*f)())
#else
void set_string_use(f)
	void (*f)();
#endif
{
	use = f;
}

#define MAX_TEXT_LENGTH	256
static char str_buffer[MAX_TEXT_LENGTH];
static char * bfp, *nlp;
static char prompt = '_';
static int name_started = 0;
static int end_with_return = 0;

#ifdef NEW_C
int get_string(pEvent *p)
#else
int get_string(p)
	pEvent *p;
#endif
{
	switch(p->kind) {
	case BTN_PRESS:
		if(name_started) return(0);
		init_text(p->x, p->y, 0);
		return(0);
	default:
		if(!name_started) return(0);
	}
	collect_text(p);
}

#ifdef NEW_C
init_text(int x, int y, int k)
#else
init_text(x, y, k)
#endif
{
	name_started = 1;
	nlp = bfp = str_buffer;
	x1 = x0 = x;	y1 = y0 = y;
	put_text("_", x1, y1);
	end_with_return = k;
}

#ifdef NEW_C
int collect_text(pEvent *p)
#else
int collect_text(p)
	pEvent *p;
#endif
{
	switch(p->kind) {
	case KEY_NORMAL:
		put_text("_", x1, y1);	/* erase prompt */
		*bfp++ = p->key;
		*bfp = 0;
		x1 += put_text(bfp-1, x1, y1);
		put_text("_", x1, y1);
		return(0);
	case KEY_ERASE:		/* backspace */
		if(bfp <= nlp) return(0);
		put_text("_", x1, y1);	/* erase prompt */
		put_text(nlp, x0, y1);	/* erase text */
		bfp--;
		*bfp = 0;
		x1 = x0 + put_text(nlp, x0, y1);
		put_text("_", x1, y1);
		return(0);
	case KEY_RETURN:	/* new line */
		if(!end_with_return) {
			put_text("_", x1, y1);	/* erase prompt */
			*bfp++ = '\n';
			nlp = bfp;
			x1 = x0; 	y1 += get_font_height()+3;
			put_text("_", x1, y1);
			return(0);
		}
	case ESCAPE:	/* complete  */
		put_text("_", x1, y1);	/* erase prompt */
		*bfp = 0;
		name_started = 0;
		bfp = str_buffer;
		if(use) use(str_buffer);
		return(0);
	default:
		return(0);
	}
}

#ifdef NEW_C
int put_NL_text(char *s, int x, int y, int compdim, int *wp, int *hp)
#else
int put_NL_text(s, x, y, compdim, wp, hp)
	char *s;
	int *wp, *hp;
#endif
{
	char *cp, *cp0;
	int y1, tmpw;

	cp0 = s;	y1 = y;
	if(compdim) *wp = 0;
	while( cp = strchr(cp0, '\n') ){
		*cp = 0;
		tmpw = put_text(cp0, x, y1);
		if(compdim) {
			if(tmpw>*wp) *wp = tmpw;
		}
		*cp = '\n';
		cp0 = cp+1;
		y1 += get_font_height()+3;
	}
	tmpw = put_text(cp0, x, y1);
	if(compdim) {
		if(tmpw>*wp) *wp = tmpw;
	*hp = y1 - y;
	}
	return(fontlength(cp0));
}

/* -------------------------------------------------------------------- */
/*
	Add a few special colors given by name.
	Labels start with a -, hence lp->label+1
*/

#ifdef NEW_C
void add_colors_by_name(pValue ll[])
#else
void add_colors_by_name(ll)
	pValue ll[];
#endif
{
	pValue *lp;

	for(lp = ll; lp->label; lp++) {
		if(*lp->label != '-') continue;
		lp->value = add_named_color(lp->label+1);
		if(lp->value<0) {
			lp->value = lp>ll? (lp-1)->value: 0;
		}
	}
}

/*	---- Procedures for modifying the cursor mask bitmap ----	*/
/*	Convert between hex and bit matrix and make cursor mask	*/
#define MAX_WIDTH	 64
#define MAX_HEIGHT	 64
static char pix[MAX_HEIGHT][MAX_WIDTH];
static int W = 16, H = 16;

#ifdef NEW_C
void make_cursor_mask(unsigned char cursor_image[], unsigned char mask_image[])
#else
void make_cursor_mask(cursor_image, mask_image)
	unsigned char cursor_image[], mask_image[];
#endif
{
	register y, x;

	make_bit_matrix(cursor_image);

	for(y=0; y<H; y++) {
		for(x=0; x<W; x++){
			if(pix[y][x]) continue;
			if(x>0)
			if(pix[y][x-1]==1) { pix[y][x] = 2; continue; }
			if(x<W-1)
			if(pix[y][x+1]==1) { pix[y][x] = 2; continue; }
			if(y>0)
			if(pix[y-1][x]==1) { pix[y][x] = 2; continue; }
			if(y<H-1)
			if(pix[y+1][x]==1) { pix[y][x] = 2; continue; }
		}
	}

	make_char_vector(mask_image);
}

static int hmask[] = { 01, 02, 04, 010, 020, 040, 0100, 0200 };

#ifdef NEW_C
void make_bit_matrix(unsigned char bits[])
#else
void make_bit_matrix(bits)
	unsigned char bits[];
#endif
{
	int y, x;
	register k, j;
	int xv;

	y = x = 0;
	for(j=0; j<32; j++) {
		xv = bits[j];
		for(k=7; k>=0; k--, x++) pix[y][x] = hmask[k]& xv ? 1: 0;
		if(x>= W) { x = 0;	y++; }
	}
	
}

#ifdef NEW_C
void make_char_vector(unsigned char bits[])
#else
void make_char_vector(bits)
	unsigned char bits[];
#endif
{
	register k, j;
	int y, x;
	int xv;

	x = y = 0;	j = 0;
	do{
		xv = 0;
		for(k=7; k>=0; k--, x++) if(pix[y][x]) xv |= hmask[k];
		bits[j++] = xv;
		if(x>= W) { x = 0;	y++; }
	} while(y<H);
}

/*	---- Dither program for monochrome displays -----	*/
/*	---- rather inefficient -------------------------	*/
static pPixel dmatrix[8][8];
static int d_m_done = 0;
static int LSBfirst_mask[] = { 01, 02, 04, 010, 020, 040, 0100, 0200 };
static int MSBfirst_mask[] = { 0200, 0100, 040, 020, 010, 04, 02, 01 };

#ifdef NEW_C
void dither(pImage * img, pPixel bit_vector[], int bitorder)
#else
void dither(img, bit_vector, bitorder)
	pImage * img;
	pPixel bit_vector[];
#endif
{
	int y, xv, j;
	register x, k;
	register pPixel *cp;
	int extra_w;
	int *hmask;

	if(!d_m_done) {
		makedither();
		d_m_done = 1;
	}

	if(bitorder) hmask = MSBfirst_mask;
	else hmask = LSBfirst_mask;

	extra_w = img->width%8;
	img->pix_w = img->width - extra_w;
	if(extra_w)
		fprintf(stderr,"width decremented by %d\n", extra_w);

	x = y = 0;	j = 0;
	cp = img->pstart;
	do{
		xv = 0;
		for(k=0; k<8; k++, x++, cp++)
			if(*cp < dmatrix[y%8][x%8]) xv |= hmask[k];
		bit_vector[j++] = xv;
		if(x >= img->pix_w) { x = 0;	cp+= extra_w;	y++; }
	} while(y<img->height);
}

/* Create dither matrices by D(2n) = 4U(2)XD(n) + D(2)XU(2) */
/* matrices are assumed to be stored as linear arrays */
#define D_2_SIZE 2
#define D_n_SIZE n

#ifdef NEW_C
void newd(pPixel *D_n, pPixel *D_2, pPixel *D_2n, int n)
#else
void newd(D_n, D_2, D_2n, n)
	pPixel *D_n;
	pPixel *D_2;
	pPixel *D_2n;
	int n;
#endif
{
	register i, j;
	int im, id;
	pPixel c, d, *v;
	int n2;

	n2 = 2*n;
	v = D_2n;
	for(i=0; i<n2; i++) {
		im = i%n;	id = i/n;
		for(j=0; j<n2; j++) {
			c = *(D_2 + id*D_2_SIZE+j/n); /* d = D_2[i/n][j/n] */
			d = *(D_n + im*D_n_SIZE+j%n); /* c = D_n[i%n][j%n] */
			*v++ = 4*d + c;
		}
	}
}

#ifdef NEW_C
void makedither()
#else
void makedither()
#endif
{
	register i, j;
	pPixel a[4], b[4], c[16], d[64];

	a[0] = a[1] = a[2] = a[3] = 1;
	b[0] = 0;	b[1] = 2;	b[2] = 3;	b[3] = 1;

	newd(b,b,c,2);	newd(c,b,d,4);

	for(i=0;i<8;i++) for(j=0;j<8;j++) dmatrix[i][j] = 4*d[i*8+j];
}

/*	Color Halftone - Inefficient Implementation	*/

static void color_htone(), simple_compose();
void make_332_RGB(), compose_color();

static pPixel v2[4] = { 0, 0140, 0240, 0377 };
static pPixel v3[8] = { 0, 060, 0120, 0160, 0220, 0260, 0320, 0377 };

#ifdef NEW_C
void compose_color(pImage *Ip, int use_htone)
#else
void compose_color(Ip, use_htone)
	pImage *Ip; int use_htone;
#endif
{
	pPixel *buff;

	if(Ip->depth != 24) return;
	buff =  (pPixel *)malloc((Ip->width*Ip->height)*sizeof(pPixel));

	if(use_htone) color_htone(Ip, buff);
	else simple_compose(Ip, buff);
	Ip->depth  = 8;
	/* construct color map */
	Ip->blue  = (pPixel *)malloc(256*sizeof(pPixel));
	Ip->green = (pPixel *)malloc(256*sizeof(pPixel));
	Ip->red   = (pPixel *)malloc(256*sizeof(pPixel));
	Ip->cmap_len = 256;
	Ip->pixel_offset = 0;
	Ip->cmap_type = 3;
	make_332_RGB(Ip->red, Ip->green, Ip->blue);
}

#define spread(e, x, y, width, height, color)		\
	if(x<width-1) *(color+1) += (3*e)/8;		\
	if(y<height-1) {				\
		*(color+width) += (3*e)/8;		\
		if(x<width-1) *(color+width+1) += e/4;	\
	}						\

#ifdef NEW_C
static void color_htone(pImage *Ip, pPixel *bf)
#else
static void color_htone(Ip, bf)
	pImage *Ip; pPixel *bf;
#endif
{
	int y, x;
	register pPixel *redp, *greenp, *bluep, *cp;
	int *red, *green, *blue;
	int *red_i, *green_i, *blue_i;
	int v, vred, vgreen, vblue;
	int e;

	printf("Halftoning color - please wait\n");

	red   = (int *)malloc((Ip->width*Ip->height)*sizeof(int));
	green = (int *)malloc((Ip->width*Ip->height)*sizeof(int));
	blue  = (int *)malloc((Ip->width*Ip->height)*sizeof(int));
	if(!red || !green || !blue) own_error(1, "No memory for r,g,b");

	bluep  = Ip->pstart;	/* loaded when read file with all data */
	greenp = bluep + 1;
	redp   = greenp + 1;
	red_i   = red;
	green_i = green;
	blue_i  = blue;
	
	/* construct integer matrices */
	for(y=0; y<Ip->height; y++) {
		for(x=0; x<Ip->width;
			x++, bluep += 3, greenp += 3, redp += 3,
			red_i++, green_i++, blue_i++) {
				*red_i = *redp;
				*green_i = *greenp;
				*blue_i = *bluep;
		}
	}

	/* use error diffusion for htone */
	cp = bf;
	red_i   = red;
	green_i = green;
	blue_i  = blue;
	for(y=0; y<Ip->height; y++) {
		for(x=0; x<Ip->width;
		x++, red_i++, green_i++, blue_i++, cp++) {
			v = *red_i>>5; if(v>7) v = 7; if(v<0) v = 0;
			vred = v3[v];
			e = *red_i - vred;
			spread(e, x, y, Ip->width, Ip->height, red_i) /*Macro*/

			v = *green_i>>5; if(v>7) v = 7; if(v<0) v = 0;
			vgreen = v3[v];
			e = *green_i - vgreen;
			spread(e, x, y, Ip->width, Ip->height, green_i) /*Mac*/

			v = *blue_i>>6;	if(v>3) v = 3; if(v<0) v = 0;
			vblue = v2[v];
			e = *blue_i - vblue;
			spread(e, x, y, Ip->width, Ip->height, blue_i) /*Macro*/

			*cp = vred&0340 | (vgreen>>3)&034 | (vblue>>6)&03;
			if(!*cp) *cp = 1;
		}
	}
	free(Ip->pstart);
	Ip->pstart = bf;
}

#ifdef NEW_C
static void simple_compose(pImage *Ip, pPixel *bf)
#else
static void simple_compose(Ip, bf)
	pImage *Ip; pPixel *bf;
#endif
{
	int y, x;
	register pPixel *redp, *greenp, *bluep, *cp;

	bluep  = Ip->pstart;	/* loaded when read file with all data */
	greenp = bluep + 1;
	redp   = greenp + 1;
	cp = bf; 

	/* compose pixel values */
	for(y=0; y<Ip->height; y++) {
		for(x=0; x<Ip->width;
			x++, bluep += 3, greenp += 3, redp += 3, cp++) {
			*cp = (*redp&0340) | (*greenp>>3)&034 |
				(*bluep>>6)&03;
			if(!*cp) *cp = 1;
		}
	}
	free(Ip->pstart);
	Ip->pstart = bf;
}

#ifdef NEW_C
void make_332_RGB(pPixel red[], pPixel green[], pPixel blue[])
#else
void make_332_RGB(red, green, blue)
	pPixel red[], green[], blue[];
#endif
{
	register n;

	red[0] = green[0] = blue[0] = 255;
	red[1] = green[1] = blue[1] = 0;
	for(n=2; n<256; n++){
		red[n]   = v3[(n&0340)>>5];
		green[n] = v3[(n&034)>>2];
		blue[n]  = v2[n&03]; 
	}
}


/*	Written by Bill Sakoda - Oct. 27, 1994	*/

static int popen_pid;

#ifdef NEW_C
int two_way_pipe(char *cmd, int *to_child_p, int *from_child_p)
#else
int two_way_pipe(cmd, to_child_p, from_child_p)
	char *cmd;
	int *to_child_p, *from_child_p;
#endif
{
	int p[2];
	int q[2];

	if(pipe(p)<0) return (0);
	if(pipe(q)<0) return (0);

	/* child  reads from p[0], writes into q[1] */
	/* parent reads from q[0], writes into p[1] */

	if ((popen_pid=fork()) ==0) {	/* child code */
		close(p[1]);	close(q[0]); /* close what is not needed */

		/* setup child standard in */
		close(0);	dup(p[0]);	close(p[0]);
		/* .. and standard out */
		close(1);	dup(q[1]);	close(q[1]);

		execl("/bin/sh", "sh", "-c", cmd, 0);
		fprintf(stderr,"Cannot execute %s\n", cmd);
		exit(1);
	}
	else {	/* parent code */
		if(popen_pid== -1) return(0);
		close(p[0]);	close(q[1]); /* close what is not needed */
		*to_child_p   = p[1];
		*from_child_p = q[0];
		return(1);
	}
}

void version()
{
	printf("Starter Toolkit Version 0.7.1\n");
}
