/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
/*	Colormaps and Images	*/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Starter.h>

static Display * Dpy;
static int	d_init = 0;

static char need_server_msg[] = "No server. Use begin_display() first";
static Colormap cmap;
static Visual	*visual;	/* need for images */
static int	monochrome = 0;
static int	alloc_color = 0;

static void xquery();
static Colormap get_cmap_for_type();
static void     save_cmap_type();

#ifdef NEW_C
Visual *get_visual()
#else
Visual *get_visual()
#endif
{
	return(visual);
}

#ifdef NEW_C
int no_depth()
#else
int no_depth()
#endif
{
	return(monochrome);
}

#define FULL_DEPTH	8

#ifdef NEW_C
void init_color_map(Widget w)
#else
void init_color_map(w)
	Widget w;
#endif
{
	int screen_depth;

	Dpy = XtDisplay(w);	/* Important for any color or image work */
	d_init = 1;

	/*	Find if the server screen has appropriate depth	*/
	screen_depth  = DefaultDepth(Dpy, DefaultScreen ( Dpy ) );
	monochrome = screen_depth <  FULL_DEPTH? 1: 0;
	if(monochrome) {
		own_error(0, "Not enough bits in display (server screen).");
		own_error(0, "Some operations may not work properly");
	}
	else 	/*	Obtain the Xt color map and visual	*/
	XtVaGetValues(w, XtNcolormap, &cmap, XtNvisual, &visual, NULL);
}

typedef struct {
	int cv;		/* color value */
	XrmQuark q;     /* color name  */
	} color_pair;
#define MAX_C_N		512
static color_pair cp[MAX_C_N];
static int cpi = 0;

#ifdef NEW_C
int add_named_color(char *cname)
#else
int add_named_color(cname)
	char *cname;
#endif
{
	XColor col_def;
	XrmQuark q;
	register i, j;

	if(!d_init) own_error(1,need_server_msg);

	if(monochrome) return(-1);

	q = XrmStringToQuark(cname);
	for(i=0; i<cpi; i++) if(cp[i].q == q) return(cp[i].cv);

	if(cpi>=MAX_C_N) return(-1);

	if( ! XParseColor(Dpy, cmap, cname, &col_def) ) {
		printf("color [%s] is not defined\n", cname);
		cp[cpi].q = q;	cp[cpi].cv = -1;	cpi++;
		return(-1);
	}

	if( ! XAllocColor(Dpy, cmap, &col_def) ) {
		printf("Cannot allocate [%s]\n",cname);
		cp[cpi].q = q;	cp[cpi].cv = -1;	cpi++;
		return(-1);
	}
	else {
		cp[cpi].q = q;	cp[cpi].cv = col_def.pixel;	cpi++;
		return(col_def.pixel);
	}
}

#ifdef NEW_C
int add_RGB_color(pPixel red, pPixel green, pPixel blue)
#else
int add_RGB_color(red,  green,  blue)
	pPixel red, green, blue;
#endif
{
	XColor col_def;

	if(!d_init) own_error(1,need_server_msg);

	if(monochrome) return(-1);

	col_def.red   = red << 8;
	col_def.green = green << 8;
	col_def.blue  = blue << 8;
	col_def.flags = DoRed | DoGreen | DoBlue;

	if( ! XAllocColor(Dpy, cmap, &col_def) ) {
		printf("Cannot allocate [%d, %d, %d]\n", red, green, blue);
		return(-1);
	}
	else return(col_def.pixel);
}

#define OWN_CMAP	256
#define	QL	200

#ifdef NEW_C
int add_RGB_colors(pPixel red_pix[], pPixel green_pix[],
pPixel blue_pix[], int RGB_length)
#else
int add_RGB_colors(red_pix, green_pix, blue_pix, RGB_length)
	pPixel red_pix[], green_pix[], blue_pix[];
#endif
{
	register i, j;
	XColor ccell[OWN_CMAP];
	unsigned long plane_masks[2];
	unsigned long pixels[OWN_CMAP];
	int cstat, nr, ng, nb;	/* used to check existing colormap */
	int red[OWN_CMAP], green[OWN_CMAP], blue[OWN_CMAP];

	if(no_depth()) return -1;

	for(i=0; i<RGB_length; i++) {
		red[i]   = red_pix[i]<<8;
		green[i] = green_pix[i]<<8;
		blue[i]  = blue_pix[i]<<8;
	}

	cstat = XAllocColorCells(Dpy, cmap, True, plane_masks, 0,
		pixels, RGB_length);
	if(!cstat) {
		/* Check whether there are already there */
		for(i=0; i<OWN_CMAP; i++) ccell[i].pixel = i;
		XQueryColors(Dpy, cmap, ccell, OWN_CMAP);
		j = 0;
		for(i=0; i<OWN_CMAP; i++) {
			nr = ccell[i].red&0377000;	/* red, etc are unsigned! */
			ng = ccell[i].green&0377000;
			nb = ccell[i].blue&0377000;
			if( nr == red[i-j] && ng == green[i-j] && nb == blue[i-j]
				&& (i-j)<RGB_length ) continue;
			if( (i-j) >= RGB_length) return ccell[j].pixel;
			j = i+1;
		}
		own_error(0,"Color Cell Allocation failed");
		return 0;
	}
	for(i=0; i<RGB_length; i++) {
		ccell[i].pixel = pixels[i];
		ccell[i].red   = red[i];
		ccell[i].green = green[i];
		ccell[i].blue  = blue[i];
		ccell[i].flags = DoRed | DoGreen | DoBlue;
	}
	XStoreColors(Dpy, cmap, ccell, RGB_length);
	return pixels[0];
}


#ifdef NEW_C
int force_mono()
#else
int force_mono()
#endif
{
	monochrome = 1;
}

#ifdef NEW_C
int there_is_depth()
#else
int there_is_depth()
#endif
{
	return(monochrome? 0: 1);
}

#ifdef NEW_C
void get_color_cell(XColor *cp, char *color_name, int default_color)
#else
void get_color_cell(cp, color_name, default_color)
	XColor *cp;
	char *color_name;
#endif
{
	int offset = 0;

	if(monochrome) {
		cp->red = cp->green = cp->blue = default_color;
	}
	else {
		if(*color_name=='-') offset=1;
		if( ! XParseColor(Dpy, cmap, color_name+offset, cp) ) {
			cp->red = cp->green = cp->blue = default_color;
		}
		/* otherwise *cp got the right RGB values */
	}
}

#ifdef NEW_C
static void xquery(Colormap cmp, int n1, int n2, int n3)
#else
static void xquery(cmp, n1, n2, n3)
	Colormap cmp;
#endif
{
	XColor cq[QL], *cqp;
	register i;

	if(!d_init) own_error(1,need_server_msg);

	for(i=0;i<QL; i++) {
		cq[i].pixel = i;
		cq[i].flags = DoRed | DoGreen | DoBlue;
	}
	XQueryColors(Dpy, cmp, cq, QL);
	for(i=n1, cqp=cq+n1; i<n2; i+=n3, cqp+=n3)
		printf("%d [%5d %5d %5d]\n", cqp->pixel,
			((cqp->red)>>8)&0377,
			((cqp->green)>>8)&0377,
			((cqp->blue)>>8)&0377);
}

#define WHITE	    0
#define LIGHT_BEIGE 2	/* select more carefully */
#define DARK_BEIGE  3	/* select more carefully */

#ifdef NEW_C
int beige(char c)
#else
int beige(c)
	char c;
#endif
{
	if(!d_init) own_error(1,need_server_msg);

	if(monochrome || c=='w') return(add_named_color("white"));
	switch(c){
	case 'l': return(add_named_color("gray80"));
	case 'd': return(add_named_color("gray60"));
	}
}

/*	Start of cludgy code - disabled for now	*/

static Colormap CM[8] = { 0, 0, 0, 0, 0, 0, 0, 0};

#ifdef NEW_C
static Colormap get_cmap_for_type(int n)
#else
static Colormap get_cmap_for_type(n)
#endif
{
	/*if(0<=n && n<8) return CM[n];
	else return 0;*/
	/*if(!n) return CM[0];
	else*/ return 0;
}

#ifdef NEW_C
static void save_cmap_type(int n, Colormap cmp)
#else
static void save_cmap_type(n, cmp)
	Colormap cmp;
#endif
{
	CM[n] = cmap;
}

/*	End of cludgy code	*/

static int colormap_to_top = 0;

push_colormap_up()
{
	colormap_to_top = 1;
}

#ifdef NEW_C
void make_special_map(Widget w, pImage *img)
#else
void make_special_map(w, img)
	Widget w;
	pImage *img;
#endif
{
	register i;
	int cmap_offset;
	XColor colors[OWN_CMAP];
	Colormap w_cmap;
	Widget wt;

	if(!d_init) own_error(1,need_server_msg);
	if(no_depth()) return;

	if( !(w_cmap = get_cmap_for_type(img->cmap_type)) ) {

		w_cmap = XCreateColormap( Dpy, DefaultRootWindow(Dpy),
			DefaultVisual(Dpy, DefaultScreen(Dpy)), AllocAll);

		cmap_offset = img->pixel_offset;
		/*	save some colors	*/
		if(cmap_offset) {
			for(i=0; i< cmap_offset; i++) {
				colors[i].pixel = i;
				colors[i].flags = DoRed | DoGreen | DoBlue;
			}
			XQueryColors(Dpy,  cmap, colors, cmap_offset);
			XStoreColors(Dpy, w_cmap, colors, cmap_offset);
		}
		set_RGB_colors(w_cmap, cmap_offset,
			img->red, img->green, img->blue, img->cmap_len);
		save_cmap_type(img->cmap_type, w_cmap);
	}
	XtVaSetValues(w, XtNcolormap, w_cmap, NULL);
	/*	decide how to propagate	*/
	wt = XtParent(w);
	if(XtIsShell(wt)) {
		XtVaSetValues(wt, XtNcolormap, w_cmap, NULL);
		return;
	}
	/*	Here if internal widget	- find top widget */
	while(XtParent(wt)) wt = XtParent(wt);
	if(!XtIsShell(wt)) {
		own_error(0,"Top widget is not shell ?!?!");
		return;
	}
	if(colormap_to_top) {	/* propagate colormap */
			XtVaSetValues(wt, XtNcolormap, w_cmap, NULL);
	}
	else {
		XtSetWMColormapWindows(wt, &w, 1);
		own_error(0, "Smart WM expected to load colormap in subwindow");
	}
}

#ifdef NEW_C
int set_RGB_colors(	Colormap kmap, int koff,
	pPixel red[],
	pPixel green[],
	pPixel blue[],
	int n)
#else
int set_RGB_colors(kmap, koff, red, green, blue, n)
	Colormap kmap;
	pPixel red[], green[], blue[];
#endif
{
	register i;
	unsigned short j;
	XColor colors[OWN_CMAP], color;

	if(!d_init) own_error(1, need_server_msg);

	if(no_depth()) return(-1);
	if( n > OWN_CMAP) return(-1);
	
	/*	Create array of color cells	*/
	for(j=0, i=koff; j<n; i++, j++) {
		colors[j].pixel  = i;
		colors[j].red = red[j]<<8;
		colors[j].green = green[j]<<8;
		colors[j].blue = blue[j]<<8;
		colors[j].flags = DoRed | DoGreen | DoBlue;
	}
	/*	Add new colors  */
	XStoreColors(Dpy, kmap, colors, n);
	return(0);
}

/*	The following two procuderes are intended for 1-bit images	*/
/*	1-bit images can be displayed only when server	*/
/*	storage is used - see paper_use.c : put_image()	*/

static int mask_1[] = { 01, 02, 04, 010, 020, 040, 0100, 0200 };
static int mask_2[] = { 0200, 0100, 040, 020, 010, 04, 02, 01 };
	
#ifdef NEW_C
void flip_bytes(pImage *img)
#else
void flip_bytes(img)
	pImage *img;
#endif
{
	register i, k;
	register pPixel *cp;
	int n;
	pPixel q;

	n = img->width/8;	n *= img->height;
	for(i=0, cp=img->pstart; i<n; i++, cp++) {
		q = 0;
		for(k=0; k<8; k++) if(*cp & mask_1[k]) q |= mask_2[k];
		*cp = q;
	}
}

#ifdef NEW_C
void setup_j_image(pImage *img)
#else
void setup_j_image(img)
	pImage *img;
#endif
{
	int	Scr = DefaultScreen(Dpy);
	Pixmap	px;
	unsigned long fg, bg;

	fg = BlackPixel(Dpy, Scr);
	bg = WhitePixel(Dpy, Scr);
	flip_bytes(img);

	px = XCreatePixmapFromBitmapData(Dpy, DefaultRootWindow(Dpy),
		img->pstart, img->width, img->height,
		fg, bg, DefaultDepth(Dpy, Scr) );

	img->ID = (int)px;	/* risky */
}

#define SERVER_STORE

#ifdef NEW_C
void setup_b_image(pImage *img)
#else
void setup_b_image(img)
	pImage *img;
#endif
{
	pPixel *ibits; /* ibits are needed - they are like pixels */
	int bitorder;
	XImage *xi;
	Pixmap  px;
	static GC gc;
	int	Scr = DefaultScreen(Dpy);

	if(!d_init) own_error(1,need_server_msg);

	bitorder = BitmapBitOrder(Dpy)==MSBFirst? 1: 0;
	ibits = (pPixel *)malloc(img->height*img->width*sizeof(pPixel));
	if(!ibits) own_error(1, "No memory for halftoning");

	dither( img, ibits, bitorder );

	xi = XCreateImage(Dpy, get_visual(),
		1 /*bits/pel*/, XYBitmap, 0, ibits,
		img->pix_w, img->height, 8, 0);

#ifdef SERVER_STORE
	px = XCreatePixmap(Dpy, DefaultRootWindow(Dpy),
			img->width, img->height, /* 1);	 1 is cludge */
			DefaultDepth(Dpy, Scr) );
	img->ID = (int)px;

	if(!gc) {
		gc = XCreateGC( Dpy, px, NULL, NULL);
		XSetFunction(Dpy, gc, GXcopyInverted);
	}
	XPutImage(Dpy, px, gc, xi, 0, 0, 0, 0, img->width, img->height);

	XFree((caddr_t)xi);
#else
	img->ID = (int)xi;
#endif
	return;
}

static void drop_bit(img)
	pImage *img;
{
	register pPixel *cp;
	register i, j;

	for(j=0, cp = img->pstart; j<img->height; j++)
		for(i=0; i<img->width; i++, cp++) *cp = (*cp>>1)&0177;
}


#ifdef TIGHT_MEM
static int gray_cmap_set = 0;
#endif

#ifdef NEW_C
void prepare_gray(pImage *img)
#else
void prepare_gray(img)
	pImage *img;
#endif
{
	register i, j;
	register pPixel *cp;
	register pPixel *red, *green, *blue;
	int nRGB = 128;

	if(no_depth()) return;

	if(img->cmap_len<1 || img->cmap_type<1) {
		img->red   = (pPixel *)malloc(nRGB*sizeof(pPixel));
			if(!img->red) own_error(1, "No space for colormap");
		img->green = (pPixel *)malloc(nRGB*sizeof(pPixel));
			if(!img->green) own_error(1, "No space for colormap");
		img->blue  = (pPixel *)malloc(nRGB*sizeof(pPixel));
			if(!img->blue) own_error(1, "No space for colormap");
		img->cmap_type = 9;		/* why 9? */
	}
	drop_bit(img);
	img->cmap_len     = nRGB;
	img->pixel_offset = 64;	/* To be used only when special map is made */

#ifdef TIGHT_MEM
	if(gray_cmap_set) return;

	gray_cmap_set = 1;
#endif
	red   = img->red;
	green = img->green;
	blue  = img->blue;
	for(i=0; i<128; i++) *red++ = *green++ = *blue++ = i<<1;

}

#ifdef NEW_C
int is_gray(pImage *img)
#else
int is_gray(img)
	pImage *img;
#endif
{
	register i;
	register pPixel *red, *green, *blue;

	if(img->cmap_len != 256) return 0;	/* no need to bother with short maps */
	for(i=0, red=img->red, green=img->green, blue=img->blue;
		i<img->cmap_len; i++, red++, green++, blue++) {
			if(*red != *blue) return 0;
			if(*red != *green) return 0;
	}
	return 1;
}

#ifdef NEW_C
void setup_z_image(pImage *img)
#else
void setup_z_image(img)
	pImage *img;
#endif
{
	XImage *xi;
	Pixmap  px;
	static GC gc = 0;
	int	Scr = DefaultScreen(Dpy);

	if(!d_init) own_error(1,need_server_msg);

	xi = XCreateImage(Dpy, get_visual(),
		8 /*bits/pel*/, ZPixmap, 0, img->pstart,
		img->width, img->height, 8, 0);

	XAddPixel(xi, (long)img->pixel_offset);	/* colormap offset */

#ifdef SERVER_STORE
	px = XCreatePixmap(Dpy, DefaultRootWindow(Dpy),
			img->width, img->height,
			DefaultDepth(Dpy, Scr) );
	img->ID = (int)px;

	if(!gc) {
		gc = XCreateGC( Dpy, DefaultRootWindow( Dpy ), NULL, NULL);
		XSetFunction(Dpy, gc, GXcopy);
	}
	XPutImage(Dpy, px, gc, xi, 0, 0, 0, 0, img->width, img->height);

	XFree((caddr_t)xi);
#else
	img->ID = (int)xi;
#endif
	return;
}

#ifdef NEW_C
int setup_image(pImage *img)
#else
int setup_image(img)
	pImage *img;
#endif
{
	if(!d_init) own_error(1,need_server_msg);

	if(img->depth<2) {	/* 1 bit image */
		setup_j_image(img);
	}
	else {
		if(no_depth()) setup_b_image(img);
		else setup_z_image(img);
	}
	return(0);
}

#ifdef NEW_C
int free_image(pImage *img)
#else
int free_image(img)
	pImage *img;
#endif
{
	if(!d_init) own_error(1,need_server_msg);

	free(img->pstart);
}

/*	Creates x-images out of icons	*/

#ifdef NEW_C
XImage *icon_image(char *cv, int w, int h, int perverse)
#else
XImage *icon_image(cv, w, h, perverse)
	char *cv;
#endif
{
	XImage *xi;

	if(!d_init) own_error(1,need_server_msg);

	xi = XCreateImage(Dpy, DefaultVisual(Dpy, DefaultScreen(Dpy)),
		1, XYBitmap, 0, cv, w, h, 8, 0);

	if(perverse) {
		if(BitmapBitOrder(Dpy)==MSBFirst)
			xi->bitmap_bit_order = LSBFirst;
		else xi->bitmap_bit_order = MSBFirst;
		if(ImageByteOrder(Dpy)==MSBFirst) xi->byte_order = LSBFirst;
		else xi->byte_order = MSBFirst;
	}
	return(xi);
}

#ifdef NEW_C
Pixmap icon_pixmap(char *iconbits, int width, int height, int depth )
#else
Pixmap icon_pixmap(iconbits, width, height, depth)
	char *iconbits;
#endif
{
	return
		XCreatePixmapFromBitmapData( Dpy, DefaultRootWindow(Dpy),
		iconbits, width, height, depth, 0,
		DefaultDepth(Dpy, DefaultScreen ( Dpy ) ) );
}

/*	Image with predefined colors from default map	*/

#ifdef NEW_C
void make_image(pImage *img, pPixel *data, int width, int height,
					int colors[])
#else
void make_image(img, data, width, height, colors)
	pImage *img; pPixel *data; int width, height,  colors[];
#endif
{
	register y, x;
	register pPixel *p;
	pPixel *cp, *cp0;
	XImage *xi;
	Pixmap px;
	static GC gc = 0;
	int white = add_named_color("white");
     int     Scr = DefaultScreen(Dpy);

	cp0 = (pPixel *)malloc(width*height*sizeof(pPixel));
	if(!cp0) own_error(1,"No memory");

	for(y=0, p=data, cp=cp0; y<height; y++)
		for(x=0; x<width; x++, p++, cp++) {
			if(*p>0) *cp = colors[*p-1];
			else *cp = white;
		}
	img->pstart = cp0;
	img->width  = width;
	img->height = height;
	img->depth  = 8;

	if(no_depth()) setup_b_image(img);

	else {
		xi = XCreateImage(Dpy, get_visual(), 8 /*bpp*/, ZPixmap, 0,
			cp0, width, height, 8, 0);
		px = XCreatePixmap(Dpy, DefaultRootWindow(Dpy),
			width, height, DefaultDepth(Dpy, Scr));
		if(!gc) {
			gc = XCreateGC( Dpy, DefaultRootWindow( Dpy ),
						NULL, NULL);
			XSetFunction(Dpy, gc, GXcopy);
		}
		XPutImage(Dpy, px, gc, xi, 0, 0, 0, 0, width, height);
		img->ID = (int)px;
		XFree((caddr_t)xi);
	}
}
