/*****************************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/

/*****************************************************************
ACKNOWLEDGEMENT: The Motif versions of this code have been
written by Bill Sakoda
******************************************************************/

/*	Widget Set Dependent Routines		*/

#include <string.h>

#undef WIDGET_SET

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

extern XImage *icon_image();
extern Pixmap icon_pixmap();

#ifdef ATHENA
#define WIDGET_SET
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Form.h>

#define	MASTER_CLASS		boxWidgetClass
#define B_BOARD_CLASS		formWidgetClass

#define PUSH_BUTTON_CLASS	toggleWidgetClass
#define PUSH_BUTTON_ACTION	XtNcallback

#define VERTICAL_STACK		XtNorientation, XtorientVertical
#define HORIZONTAL_STACK	XtNorientation, XtorientHorizontal

#define TEXT_LABEL(A)		XtNlabel,	A
#define ICON_LABEL		XtNresize,	TRUE	/* phony place holder */
#define ICON_FOR_LABEL(I,Q)	XtNbitmap, icon_pixmap(I, atoi(Q), atoi(Q), 1)
#endif

#ifdef OLIT
#define WIDGET_SET
#include <Xol/OpenLook.h>
#include <Xol/ControlAre.h>
#include <Xol/BulletinBo.h>
#include <Xol/OblongButt.h>
#include <Xol/RectButton.h>
#include <Xol/Caption.h>
#include <Xol/Exclusives.h>
#include <Xol/Nonexclusi.h>

#define	MASTER_CLASS		controlAreaWidgetClass
#define B_BOARD_CLASS		bulletinBoardWidgetClass
	
#define PUSH_BUTTON_ACTION	XtNselect
#define PUSH_BUTTON_CLASS	rectButtonWidgetClass

#define AP_INITIALIZE		OlInitialize

#define VERTICAL_STACK		XtNlayoutType,	OL_FIXEDCOLS

#define TEXT_LABEL(A)		XtNlabel,	A
#define ICON_LABEL		XtNlabelType,   OL_IMAGE
#define ICON_FOR_LABEL(I,Q)	XtNlabelImage, \
					icon_image(I, atoi(Q), atoi(Q), 1)
#endif

#ifdef MOTIF
#define WIDGET_SET
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/ToggleBG.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>
#include <Xm/DrawingA.h>
#include <Xm/LabelG.h>

#define	MASTER_CLASS		xmRowColumnWidgetClass
#define B_BOARD_CLASS		xmBulletinBoardWidgetClass
#define PUSH_BUTTON_ACTION	XmNarmCallback
#define PUSH_BUTTON_CLASS	xmToggleButtonWidgetClass
#define AP_INITIALIZE		XtInitialize
#define VERTICAL_STACK		XmNorientation, XmVERTICAL
#define TEXT_LABEL(A)		XmNlabelString, XmStringCreateSimple(A)
#define ICON_LABEL		XmNlabelType,   XmPIXMAP
#define ICON_FOR_LABEL(I,Q)	XmNlabelPixmap, \
					icon_pixmap(I, atoi(Q), atoi(Q), 1)
#endif

static Widget toplevel, base_w;

#ifdef NEW_C
void pass_to_popups(Widget w)
#else
void pass_to_popups(w)
	Widget w;
#endif
{
	base_w = w;
}

#ifdef NEW_C
Widget  base_widget()
#else
Widget  base_widget()
#endif
{
	return(base_w);
}

#ifdef NEW_C
void retitle(char *s)
#else
void retitle(s)
	char *s;
#endif
{
#ifdef WIDGET_SET
#ifdef OLIT
	XtVaSetValues(toplevel, XtNtitle, s, NULL);
#endif
#ifdef MOTIF
#endif
#else
	printf("No variable titles for stand alone as yet\n");
	printf("It would have been: %s\n", s);
#endif
}

static int  arc_maybe   = 1;
static char **arv_maybe = 0;
static char *arv_back[2] = {"stProgram", "?"};

#ifdef NEW_C
void arguments(int arc, char **arv)
#else
void arguments(arc, arv)
	int arc; char **arv;
#endif
{
	arc_maybe = arc;
	arv_maybe = arv;
	pass_arguments(arc, arv);
}

#ifdef WIDGET_SET
/*	Creation of Top Widget and Canvas	*/
extern void active_group();
static Widget make_button();
static int panel_columns(), label_length(), pan_size(), panel_rows();
void reset_all_action_panels();

static int WIDTH  = 300;
static int HEIGHT = 300;

static	XtAppContext app;

char *appclass = "StProgram";

#ifdef NEW_C
void begin_display(int w_width, int w_height, char *window_name)
#else
void begin_display(w_width, w_height, window_name)
	char *window_name;
#endif
{
	WIDTH  = w_width;
	HEIGHT = w_height;

	if(!arv_maybe) arv_maybe = arv_back;

#ifdef ATHENA
	toplevel = XtAppInitialize( &app, appclass,
		NULL, 0, &arc_maybe, arv_maybe, NULL, NULL, 0);

#else
	toplevel = AP_INITIALIZE( window_name, appclass,
		NULL, 0, &arc_maybe, arv_maybe);

	app = XtWidgetToApplicationContext(toplevel);
#endif
	XtVaSetValues(toplevel, XtNtitle, window_name, NULL);

#ifdef MOTIF
	XtVaSetValues(toplevel, XmNkeyboardFocusPolicy, XmPOINTER, NULL);
#else
	XtVaSetValues(toplevel, XtNinput, True, NULL);
#endif
	set_window_icon(toplevel);
	set_server( XtDisplay(toplevel) );
	set_application(app);
	init_color_map(toplevel);

	base_w = XtVaCreateManagedWidget("base_w",
		MASTER_CLASS, toplevel,
		VERTICAL_STACK,
		XtNborderWidth, 2,	/* watch out for Motif */
		NULL);
}

#ifdef NEW_C
void complete_display()
#else
void complete_display()
#endif
{
	if(WIDTH>4 && HEIGHT>4) setup_canvas(WIDTH, HEIGHT);
	XtRealizeWidget(toplevel);
#ifdef ATHENA
	set_protocol(toplevel);
#endif
	if(WIDTH>4 && HEIGHT>4) complete_canvas();
	active_group(0);
}

/*	Panels and Buttons		*/
#include <Starter.h>
static char **iconhold;
#define MAX_GR 16
static Widget  bb, group[MAX_GR];
static int group_n = -1;
static int previous_group, current_group;
static int desired_cols = 0, kols;

#ifdef NEW_C
void desired_columns(int n)
#else
void desired_columns(n)
#endif
{
	desired_cols = n;	/* for exclusive panel */
}

#ifdef NEW_C
void advance_group()
#else
void advance_group()
#endif
{
	char bf[16];

	if(group_n == -1) {     /* initialize */
		bb = XtVaCreateManagedWidget("bb",
		B_BOARD_CLASS, base_widget(), NULL);
	}
	group_n++;
	if(group_n<0 || group_n>=MAX_GR) {
		own_error(0,"Too many groups");
		return;
	}
	sprintf(bf,"group%02d",group_n);
	group[group_n] = XtVaCreateManagedWidget(
		bf,
		MASTER_CLASS, bb,
		VERTICAL_STACK,
		XtNborderWidth, 2,  	/* watch out for Motif */
		NULL);
}

/*     Caution: There are group_n+1 children   */

#ifdef NEW_C
void active_group(int k)
#else
void active_group(k)
#endif
{
	register j;

	if(k<0 || k>group_n) return;

	if(k!=current_group) {  /* needed for initialization */
		previous_group = current_group;
		current_group  = k;
	}
	
	for(j=0;j<=group_n; j++) XtUnmapWidget(group[j]);
	XtMapWidget(group[k]);
}

#define MAX_PAN	1024
static Widget button_array[MAX_PAN], button_pressed;
static int button_number = 0;
/*	Panels and Buttons	*/
typedef struct {
	int (*f)();
	int (*af)();
	} f_a_pair;
static f_a_pair fa[128];
static f_a_pair *fap = fa;

#ifdef NEW_C
void a_generic(Widget w, XtPointer client_data, XtPointer call_data)
#else
void a_generic(w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;
#endif
{
	f_a_pair *p;
	int need_reset;

	button_pressed = w;

	p = (f_a_pair *)client_data;

	if(p->f) p->f();	/* common preparation */

	if(p->af) need_reset = p->af();

	if(need_reset){
#ifdef OLIT
		XtVaSetValues(w, XtNset, FALSE, NULL);
#endif
#ifdef ATHENA
		XtVaSetValues(w, XtNstate, FALSE, NULL);
#endif
#ifdef MOTIF
		/* Apparently not needed */
#endif
	}
}

#ifdef NEW_C
int setup_a_panel(char *caption, pAction *a,
	int (*rfun)(),	char **icons)
#else
int setup_a_panel(caption, a, rfun, icons)
	char *caption;
	pAction *a;
	int (*rfun)();
	char **icons;
#endif
{
	pAction *ap;
	Widget cap, pex, bt;
#ifdef MOTIF
	Widget l_radio;
#endif
	register j;

	iconhold = icons;

	if(group_n<0) advance_group();

#ifdef OLIT
	kols = desired_cols>0?  desired_cols: panel_columns(a);

#endif
#ifdef MOTIF
	kols = desired_cols>0?	pan_size(a)/desired_cols: panel_rows(a);
#endif

	make_container(&pex, caption, 0);

	for(ap=a, j=0; ap->label; ap++, fap++, j++) {
		fap->f = rfun;
		fap->af = ap->fun;
		bt =  make_button(ap->label, pex, iconhold, j);
		button_array[button_number++] = bt;
		if(ap->fun)
			XtAddCallback(bt, PUSH_BUTTON_ACTION, a_generic, fap);

	}
	return(j);
}

typedef struct {
	int (*f)();
	int v;
	} f_v_pair;
static f_v_pair fv[128];
static f_v_pair *fvp = fv;

#ifdef NEW_C
void v_generic(Widget w, XtPointer client_data, XtPointer call_data)
#else
void v_generic(w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;
#endif
{
	f_v_pair *p;
	int need_reset;

	p = (f_v_pair *)client_data;

	if(p->f) need_reset = p->f(p->v);

	if(need_reset){
#ifdef OLIT
		XtVaSetValues(w, XtNset, FALSE, NULL);
#endif
#ifdef ATHENA
		XtVaSetValues(w, XtNstate, FALSE, NULL);
#endif
#ifdef MOTIF
		/* Apparently not needed */
#endif
	}
}

#ifdef NEW_C
int setup_v_panel(char *caption, pValue *v,
	int (*rfun)(), char **icons)
#else
int setup_v_panel(caption, v, rfun, icons)
	char *caption;
	pValue *v;
	int (*rfun)();
	char **icons;
#endif
{
	pValue *vp;
	Widget cap, pex, bt;
#ifdef ATHENA
	Widget first_bt;
#endif
	register j;

	iconhold = icons;

	if(group_n<0) advance_group();

#ifdef OLIT
	kols = desired_cols>0?  desired_cols:
			panel_columns((pAction *)v);
#endif
#ifdef MOTIF
	kols = desired_cols>0?	pan_size((pAction *)v)/desired_cols:
		panel_rows((pAction *)v);
#endif

	make_container(&pex, caption, 1);

	for(vp=v, j=0; vp->label; vp++, fvp++, j++) {
		fvp->f = rfun;
		fvp->v = vp->value;
		bt = make_button(vp->label, pex, iconhold, j);
#ifdef ATHENA
		if(!j) first_bt = bt;
		else XtVaSetValues(bt, XtNradioGroup, first_bt, NULL);
#endif
		if(rfun) XtAddCallback(bt, PUSH_BUTTON_ACTION, v_generic, fvp);
	}
	return(j);
}

#ifdef NEW_C
make_container(Widget *panelw, char *caption, int val)
#else
make_container(panelw, caption, val)
	Widget *panelw;
	char *caption;
	int val;
#endif
{
	Widget cap;
#ifdef ATHENA
	*panelw = XtVaCreateManagedWidget("panel",
		boxWidgetClass, group[group_n],
		XtNorientation, XtorientHorizontal,
		XtNbackground,  beige('l'),
		NULL);

	cap = XtVaCreateManagedWidget(caption,
		labelWidgetClass, *panelw,
		XtNlabel, caption,
		XtNbackground,  beige('l'),
		NULL);
#endif
#ifdef OLIT
	cap = XtVaCreateManagedWidget(caption,
		captionWidgetClass, group[group_n],
		XtNbackground,  beige('l'),
		XtNborderWidth, 2,
		TEXT_LABEL(caption),
		NULL);

	*panelw = XtVaCreateManagedWidget("ExPanel",
		exclusivesWidgetClass, cap,
		XtNbackground,  beige('l'),
		XtNborderWidth, 2,
		XtNnoneSet, TRUE,	/* do not use if there are defaults */
		VERTICAL_STACK,
		XtNmeasure,	kols,
		NULL);
#endif
#ifdef MOTIF
	Widget l_radio;

	l_radio = XtVaCreateManagedWidget("ExPanel",
		xmRowColumnWidgetClass, group[group_n],
		XmNisHomogeneous, False,
                XmNorientation, XmHORIZONTAL,				      
                XmNpacking, XmPACK_TIGHT,
		XtNbackground,  beige('l'),
		NULL);

	cap = XtVaCreateManagedWidget(caption,
		xmLabelGadgetClass, l_radio,
		XtNbackground,  beige('l'),
		TEXT_LABEL(caption),
		NULL);

	*panelw = XtVaCreateManagedWidget("ExPanel",
		xmRowColumnWidgetClass, l_radio,
		XtNbackground,  beige('l'),
                XmNorientation, XmHORIZONTAL,				      
		XmNisHomogeneous, False,
                XmNpacking, XmPACK_COLUMN,
                XmNnumColumns, kols,
		XmNradioBehavior, True,
		NULL);
#endif
}

#ifdef NEW_C
static Widget make_button(char *label, Widget parent,
	char **iconhold, int pix_ix)
#else
static Widget make_button(label, parent, iconhold, pix_ix)
	char    *label;
	Widget  parent;
	char	**iconhold;
	int     pix_ix;
#endif
{
	int tmp_color;
	Widget bt;
	char *cp = label+1;

	switch(*label) {
		case '-':
			tmp_color = add_named_color(cp);
			if(tmp_color < 0) tmp_color = beige('l');

			bt = XtVaCreateManagedWidget(label+1,
				PUSH_BUTTON_CLASS, parent,
				TEXT_LABEL(" "),
				XtNwidth,	32, 
				XtNheight,	24,
				XtNbackground,	tmp_color,
				NULL);	
			break;
		case '@':
			bt= XtVaCreateManagedWidget(label,
				PUSH_BUTTON_CLASS, parent,
				ICON_LABEL,
				ICON_FOR_LABEL(iconhold[pix_ix], cp),
				XtNbackground,  beige('l'),
				NULL);
			break;
		default:
			bt= XtVaCreateManagedWidget(label,
				PUSH_BUTTON_CLASS, parent, TEXT_LABEL(label),
				XtNbackground,  beige('l'),
				NULL);
	}

	return(bt);
}

#ifdef NEW_C
static int panel_columns(pAction *ap)
#else
static int panel_columns(ap)
	pAction *ap;
#endif
{
	pAction *lp;
	int pixlen = 0, n, ncol;

	for(lp=ap,n=0; lp->label; lp++,n++) pixlen += label_length(lp->label);
	ncol = (WIDTH*n)/pixlen + 1;

	return ncol;
}

#ifdef NEW_C
static int panel_rows(pAction *ap)
#else
static int panel_rows(ap)
	pAction *ap;
#endif
{
	pAction *lp;
	int pixlen = 0, n, nrow;

	for(lp=ap,n=0; lp->label; lp++,n++) pixlen += label_length(lp->label);
	nrow = pixlen/WIDTH + 1;

	return nrow;
}

#ifdef NEW_C
static int label_length(char *s)
#else
static int label_length(s)
	char *s;
#endif
{
	switch(*s){
		case '-': return( 24 );
		case '@': return( atoi(s+1) );
		default:  return( strlen(s)*12);
	}
}

#ifdef NEW_C
static int pan_size(pAction *ap)
#else
static int pan_size(ap)
	pAction *ap;
#endif
{
	pAction *lp;
	int n;

	for(lp=ap,n=0; lp->label; lp++,n++) ;
	return n;
}

#ifdef NEW_C
void reset_all_action_panels()
#else
void reset_all_action_panels()
#endif
{
	register i;

	for(i=0; i<button_number; i++) {
		if(button_array[i] == button_pressed) continue;
#ifdef OLIT
		XtVaSetValues( button_array[i], XtNset, FALSE, NULL);
#endif
#ifdef ATHENA
		XtVaSetValues( button_array[i], XtNstate, FALSE, NULL);
#endif
	}
}
#endif
