/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/
/*	Create Paper Widget and Support Functions	*/

#include <string.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Paper.h>
#include <Starter.h>

/*	Facility for Debugging	*/
static char *event_name[] = {
 "?",
 "??",
 "KeyPress",
 "KeyRelease",
 "ButtonPress",
 "ButtonRelease",
 "MotionNotify",
 "EnterNotify",
 "LeaveNotify",
 "FocusIn",
 "FocusOut",
 "KeymapNotify",
 "Expose",
 "GraphicsExpose",
 "NoExpose",
 "VisibilityNotify",
 "CreateNotify",
 "DestroyNotify",
 "UnmapNotify",
 "MapNotify",
 "MapRequest",
 "ReparentNotify",
 "ConfigureNotify",
 "ConfigureRequest",
 "GravityNotify",
 "ResizeRequest",
 "CirculateNotify",
 "CirculateRequest",
 "PropertyNotify",
 "SelectionClear",
 "SelectionRequest",
 "SelectionNotify",
 "ColormapNotify",
 "ClientMessage",
 "MappingNotify",
 "LASTEvent",
0};

extern draw_area();				/* in use_paper.c */
extern deliver_selection();		/* in use_paper.c */
extern void give_up_selection();	/* in use_paper.c */

/* Functions defined below */
extern void own_handler(),  w_set_handler(), w_set_redraw(), set_protocol();
static void compute_position(), top_level_handler();

extern Widget base_widget();
static	XtAppContext app = 0;

#ifdef NEW_C
void set_application(XtAppContext a)
#else
void set_application(a)
	XtAppContext a;
#endif
{
	app = a;
}

/*	Icon for Starter Toolkit Files	*/
#define starter_width 48
#define starter_height 48
static char starter_bits[] = {
   0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xc1, 0x00, 0x00,
   0x00, 0x80, 0x0f, 0x00, 0x03, 0x00, 0x00, 0x70, 0x00, 0x00, 0x0c, 0x00,
   0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0xd0, 0x00, 0x00, 0xc0, 0x00,
   0x00, 0x30, 0x03, 0x00, 0x00, 0x03, 0x00, 0x90, 0x0c, 0x00, 0x00, 0x0c,
   0x00, 0x90, 0x78, 0x00, 0x00, 0x0e, 0x00, 0x30, 0xa2, 0x03, 0xe0, 0x09,
   0x00, 0x30, 0x22, 0x06, 0x1f, 0x08, 0x00, 0x90, 0x88, 0xf8, 0x00, 0x08,
   0x00, 0x90, 0x88, 0x10, 0x00, 0x08, 0x00, 0x30, 0x22, 0x12, 0x38, 0x08,
   0x00, 0x30, 0x22, 0x12, 0x47, 0x08, 0x00, 0x90, 0x88, 0x10, 0x81, 0x08,
   0x00, 0x90, 0xbc, 0x18, 0x81, 0x08, 0x00, 0xf0, 0xc3, 0x12, 0x41, 0x08,
   0x00, 0x3c, 0x00, 0x13, 0x41, 0x08, 0xc0, 0x03, 0x00, 0x1c, 0x39, 0x08,
   0x30, 0x00, 0x00, 0x30, 0xc7, 0x08, 0x70, 0x00, 0x00, 0xc0, 0x01, 0x09,
   0xb0, 0x01, 0x00, 0x00, 0x03, 0x09, 0x90, 0x06, 0x00, 0x00, 0x0c, 0x09,
   0x90, 0x18, 0x00, 0x80, 0x0b, 0x09, 0x30, 0x62, 0x00, 0x70, 0x08, 0x09,
   0x30, 0xa2, 0x01, 0x0e, 0x88, 0x09, 0x90, 0x88, 0xc6, 0x01, 0x68, 0x08,
   0x90, 0x88, 0x38, 0x08, 0x18, 0x0c, 0x30, 0x22, 0x0a, 0x08, 0x08, 0x03,
   0x30, 0x22, 0x0a, 0x14, 0xc8, 0x00, 0x90, 0x88, 0x08, 0x14, 0x38, 0x00,
   0x90, 0x88, 0x08, 0x24, 0x08, 0x00, 0x30, 0x22, 0x0a, 0x22, 0x08, 0x00,
   0x30, 0x22, 0x0a, 0x42, 0x08, 0x00, 0x90, 0x88, 0x08, 0x42, 0x08, 0x00,
   0x90, 0x88, 0x08, 0xe1, 0x08, 0x00, 0x30, 0x22, 0x0a, 0x9d, 0x08, 0x00,
   0x30, 0x22, 0x8a, 0x03, 0x09, 0x00, 0x90, 0x88, 0x88, 0x00, 0x09, 0x00,
   0xb0, 0x88, 0x88, 0x00, 0x08, 0x00, 0xc0, 0x22, 0x4a, 0x00, 0x08, 0x00,
   0x00, 0x23, 0x4a, 0x00, 0x0c, 0x00, 0x00, 0x8c, 0x08, 0x80, 0x03, 0x00,
   0x00, 0xb0, 0x08, 0x70, 0x00, 0x00, 0x00, 0xe0, 0x0a, 0x0e, 0x00, 0x00,
   0x00, 0x00, 0xcb, 0x01, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00
   };

static Pixmap starter_icon = 0;

#ifdef NEW_C
void set_window_icon(Widget w)
#else
void set_window_icon(w)
	Widget w;
#endif
{
	if(!starter_icon)
		starter_icon = XCreateBitmapFromData(XtDisplay(w),
			DefaultRootWindow(XtDisplay(w)),
			starter_bits, starter_width, starter_height);

	XtVaSetValues(w, XtNiconPixmap, starter_icon, NULL);
}

static int  arc_maybe   = 1;
static char **arv_maybe = 0;
static char *arv_back[2] = {"stProgram", "?"};

#ifdef NEW_C
void pass_arguments(int arc, char **arv)
#else
void pass_arguments(arc, arv)
	int arc; char **arv;
#endif
{
	arc_maybe = arc;
	arv_maybe = arv;
}

#ifdef NEW_C
Widget create_paper_widget(
	void (*redraw)(),
	void (*handler)(),
	int width, int height, int child_type,
	char *window_name)
#else
Widget create_paper_widget(redraw, handler, width, height, child_type, window_name)
	void (*redraw)();
	void (*handler)();
	char *window_name;
#endif
{
	Widget new_paper_w, parent_w;
	static char wgname[64];		/* estim. dimension carefully */
	Position xpos = 0, ypos = 0;
	static pwidget_count=0;

	parent_w = base_widget();	/* may be over-ridden */

	if(child_type==PopupChild_Q) {
		Dimension pwidth, pheight;

		child_type = PopupChild;
		if(parent_w) {
			XtVaGetValues(parent_w, XtNwidth, &pwidth,
						XtNheight, &pheight, NULL);
			XtTranslateCoords(parent_w, pwidth+4, 0,
				&xpos, &ypos);
		}
	}

	switch(child_type) {
	case NormalChild:
		break;
	case PopupChild_P:
		if(parent_w)
			compute_position(parent_w, width, height, &xpos, &ypos);
		/* NO break. For other values use (0,0) */
	case PopupChild:
		parent_w = XtVaCreatePopupShell("StPopup",
			topLevelShellWidgetClass,	parent_w,
			XtNx,		xpos,	XtNy,		ypos,
			XtNtitle,	window_name,
			NULL);
		set_window_icon(parent_w);

		break;
	case IndependentChild:
		if(!arv_maybe) arv_maybe = arv_back;

		parent_w = XtAppInitialize(
			&app,
			"StProgram",
			(XrmOptionDescList)NULL,
			0,			/* no options */
			&arc_maybe,	arv_maybe,
			(String *)NULL,		/* no fallback list */
			(ArgList) NULL,
			0);			/* no arguments */

		XtVaSetValues(parent_w,
			XtNtitle,	window_name,
			XtNinput,	True,
			NULL);
		set_window_icon(parent_w);

		set_server( XtDisplay(parent_w) );
		init_color_map(parent_w);	/* ask for full pixmap */
		break;
	default:;
	}

	pwidget_count++;
	sprintf(wgname,"paper_%d", pwidget_count);

	new_paper_w = XtVaCreateManagedWidget(wgname,
		paperWidgetClass, parent_w, 
		XtNwidth,       width,	XtNheight,      height,
		XtNborderWidth, 1,
		NULL);

	/* make draw_area first response to expose */ 
	XtVaSetValues(new_paper_w, XtNuserDraw, draw_area, NULL);

	/* assign function for delivering selection */
	XtVaSetValues(new_paper_w, XtNgiveSelection, deliver_selection, NULL);

	XtAddCallback(new_paper_w, XtNloseSelection, give_up_selection, NULL);

	if(redraw) w_set_redraw(new_paper_w, redraw);

	/* This should be called always to set own_handler */
	w_set_handler(new_paper_w, handler);

	return(new_paper_w);
}

#ifdef NEW_C
static void complete_stand_alone(Widget w)
#else
static void complete_stand_alone(w)
	Widget w;
#endif
{
	Widget wtmp;

	wtmp = XtParent(w);

	XtRealizeWidget(wtmp);

	set_protocol(wtmp);

	draw_area(w);	/* needed to setup GC before exposure */

	pass_to_popups(w);
}

#ifdef NEW_C
void popup(Widget w, int easy)
#else
void popup(w, easy)
	Widget w;
#endif
{
	Widget wtmp;

	wtmp = XtParent(w);

	if(easy) XtPopup(wtmp, XtGrabNone);
	else XtPopup(wtmp, XtGrabExclusive);

	set_protocol(wtmp);
}

#ifdef NEW_C
void popdown(Widget w)
#else
void popdown(w)
	Widget w;
#endif
{
	XtPopdown( XtParent(w) );
}

/*	Execution	*/
#ifdef NEW_C
void wait_for_event()
#else
void wait_for_event()
#endif
{
	if(app) XtAppMainLoop(app);
	else own_error(1, "No application context for main loop");
}

#ifdef NEW_C
void add_work(Boolean (*f)())
#else
void add_work(f)
	Boolean (*f)();
#endif
{
	if(app) XtAppAddWorkProc(app, f, NULL);
	else own_error(1, "No application context for background process");
}

/* fid must be a file descriptor	*/
#ifdef NEW_C
void take_from_file( int fid, void (*fun)() )
#else
void take_from_file(fid, fun)
	int fid;
	void (*fun)();
#endif
{
	XtInputId xinp;

	if(app) xinp = XtAppAddInput(app, fid, (XtPointer)XtInputReadMask,
		fun, NULL);
	else own_error(1, "No application context for background input");
}

/*	Priviledged canvas	*/
static Widget	canvas;

#ifdef NEW_C
void setup_canvas(int width, int height)
#else
void setup_canvas(width, height)
#endif
{
	static int canvas_done = 0;

	if(canvas_done) return;
	else canvas_done = 1;

	canvas = create_paper_widget(0, 0, width, height, 
		NormalChild, "canvas");
}

#ifdef NEW_C
void complete_canvas()
#else
void complete_canvas()
#endif
{
	draw_area(canvas);
	background_widget(canvas);
	select_font("fixed");
}

#ifdef NEW_C
void default_destination()
#else
void default_destination()
#endif
{
	if(canvas) draw_area(canvas);
}

/*	Ask for backing store for widget	*/
#ifdef NEW_C
int backing_store(Widget w)
#else
int backing_store(w)
	Widget w;
#endif
{
	XSetWindowAttributes attr;
	static unsigned long valuemask = CWBackingStore | CWBitGravity;

	if( DoesBackingStore( DefaultScreenOfDisplay( XtDisplay(w)) )
		!= Always) return 0;
	attr.backing_store = Always;
	attr.bit_gravity = NorthWestGravity;
	XChangeWindowAttributes(XtDisplay(w), XtWindow(w), valuemask, &attr);
	return 1;
}

/*	Compute Location of Popup (Paper) Widget	*/
/*	constant of 20 and 40 are sued to estimate frame dimensions	*/
static Position  xpos = 0, ypos = 0;
static int /*NOT Dimension */ H_EDGE = -1, V_EDGE = -1, maxheight = 0, owidth;
/*	This version starts from TL corner of screen rather than base window */

#ifdef NEW_C
static void compute_position(
	Widget	w,
	int given_width, int given_height,
	Position *r_xp, Position *r_yp)
#else
static void compute_position(w, given_width, given_height, r_xp, r_yp)
	Widget	w;
	Position *r_xp, *r_yp;
#endif
{
	Display 	*dpy = XtDisplay(w);
	Dimension	x0, y0;

	if(H_EDGE<0) H_EDGE = DisplayWidth( dpy, DefaultScreen(dpy) );
	if(V_EDGE<0) V_EDGE = DisplayHeight( dpy, DefaultScreen(dpy) );

	if(ypos+given_height +40 > V_EDGE){
		ypos = 0;	xpos = 0;
		maxheight = given_height;
	}
	else {
		if(xpos+given_width+owidth > H_EDGE) {
				ypos += maxheight+40;
				if(ypos+given_height > V_EDGE) ypos = 0;
				xpos = 0;
				maxheight = given_height;
		}
			else xpos += owidth;
	}
	if(given_height > maxheight) maxheight = given_height;

	owidth = given_width+12;	/* 12 for margin */
	*r_xp = xpos;
	*r_yp = ypos;
	return;
}	

/*	Special Stand Alone Applications	*/
#ifdef NEW_C
void create_stand_alone(int width, int height, char *title)
#else
void create_stand_alone(width, height, title)
	char *title;
#endif
{
	Widget w;

	w = create_paper_widget(0, 0, width, height, IndependentChild, title);
	complete_stand_alone(w);
}

/*	Functions using begin_/complete_ display	*/

#ifdef NEW_C
void draw_window(void (*draw)(), void (*handle)(),
	int width, int height,	char *label)
#else
void draw_window(draw, handle, width, height, label)
	void (*draw)();
	void (*handle)();
	char *label;
#endif
{
	Widget w;

	w = create_paper_widget(draw, handle, width, height,
						IndependentChild, label);
	complete_stand_alone(w);
	use_xor_mode();
	select_font("fixed");
	wait_for_event();
}

#ifdef NEW_C
void quit_w(pEvent *p)
#else
void quit_w(p)
	pEvent *p;
#endif
{
	if(p->kind==BTN_PRESS)  exit(0);
}

/* vis_window could be in terms of draw_window */
#ifdef NEW_C
void vis_window(void (*f)(), int width, int height)
#else
void vis_window(f, width, height)
	void (*f)();
#endif
{
	Widget w;

	if(width <20 || width >1000) width  = 300;
	if(height<20 || height >800) height = 200;
	w = create_paper_widget(f, quit_w, width, height,
				IndependentChild, "Press Any Button to Exit");
	complete_stand_alone(w);
	select_font("fixed");
	use_replace_mode();
	wait_for_event();
}

/* callback -  takes care of draw_area */
#ifdef NEW_C
void pixdraw(Widget w, pImage *img)
#else
void pixdraw(w, img)
	Widget w;
	pImage *img;
#endif
{
	put_image(img, 0, 0);
	default_destination();
}

#ifdef NEW_C
int IsThere(Widget wg)
#else
int IsThere(wg)
	Widget wg;
#endif
{
	XWindowAttributes attr;
	Window w = XtWindow(XtParent(wg));

	XGetWindowAttributes(XtDisplay(wg), w, &attr);
	return( attr.map_state != IsUnmapped );
}

#ifdef NEW_C
Widget img_window(pImage *img, void (*handler)(), char *label)
#else
Widget img_window(img, handler, label)
	pImage *img;
	void (*handler)();
	char *label;
#endif
{
	Widget pix_widget = 0;

	/* we pass null draw so that we can set it up properly */
	pix_widget = create_paper_widget(0, handler,
			img->width, img->height, PopupChild_P, label);
	XtAddCallback(pix_widget, XtNredrawCallback, pixdraw, img);

	return pix_widget;
}

extern GC paper_gc();

#ifdef NEW_C
void Tp_image_tile(PaperWidget w, pImage *img)
#else
void Tp_image_tile(w, img)
	PaperWidget w;
	pImage *img;
#endif
{
	Display *Dpy = XtDisplay((Widget)w);
	GC	gc   = paper_gc(w);

	if(!there_is_depth()) return;
	XSetTile(Dpy, gc, (Pixmap)img->ID);
	XSetFillStyle(Dpy, gc, FillTiled);	
	XSetFunction(Dpy, gc, GXxor);
}

/*
	Procedures that enhance the functionality of the paper widget
	but are not part of tis definition. They deal with events and
	callbacks
*/
/*	Event Handler for Shell Widget's communic. with WM	*/
static	Atom wm_quit;

#ifdef NEW_C
static void top_level_handler(Widget wg,
	XtPointer client_data,
	XEvent *ep,
	Boolean *continue_dispatch)
#else
static void top_level_handler(wg, client_data, ep, continue_dispatch)
	Widget wg;
	XtPointer client_data;
	XEvent *ep;
	Boolean *continue_dispatch;
#endif
{
	int msg_data;

	printf("%s\n", event_name[ep->type]);
	if(ep->type != ClientMessage) return;
	msg_data = ep->xclient.data.l[0];
	if(msg_data == wm_quit) exit(0);
	else XBell(XtDisplay(wg), 0);
}

/* wg should be a shell widget */
#ifdef NEW_C
void set_protocol(Widget wg)
#else
void set_protocol(wg)
	Widget wg;
#endif
{
	Display *dpy = XtDisplay(wg);

	wm_quit = XInternAtom(dpy, "WM_DELETE_WINDOW", False);

	if( ! XSetWMProtocols( dpy, XtWindow(wg), &wm_quit, 1) ) {
		printf("Cannot set protocol\n");
		return;
	}

	XtAddEventHandler(wg, 0, True, top_level_handler, NULL);
}

/*	Common event handler for paper widgets		*/

extern int (*usage_return())();
extern char *myname();

#ifdef NEW_C
void own_handler(Widget w, XtPointer client_data,
	XEvent *ep, Boolean *disp)
#else
void own_handler( w, client_data, ep, disp)
	Widget w;
	XtPointer client_data;
	XEvent *ep;
	Boolean *disp;
#endif
{
	pEvent Pen;
	int (*h)();
#ifdef DEBUG
	Widget wpar, wgpar, wm;

	wpar  = XtParent(w);
	wgpar = XtParent(wpar);
#endif

	h = (int (*)())client_data;
	Pen.origin = (long)w;

	if(ep->type != MotionNotify) {
#ifdef DEBUG
		printf("\t\tEvent %s in %s\n",
			event_name[ep->type], myname(w));
#endif
		draw_area(w);
	}

	switch(ep->type) {
	case EnterNotify:
		return;
	case LeaveNotify:
		default_destination();
		return;
	case ButtonPress:
	case ButtonRelease:
	case MotionNotify:
	case KeyPress:
		translate_events( ep , &Pen);
		if(h) h(&Pen);
		return;
	}
}

/*	Code below depends on paper widget	*/
/*	Set a single event handler with appl. handler f()	*/

#ifdef NEW_C
void w_set_handler(Widget wg, int (*g)())
#else
void w_set_handler(wg, g)
	Widget wg;
	int (*g)();
#endif
{
	void (*h)();

	XtVaGetValues(wg, XtNuserHandler, &h, NULL);
	XtRemoveEventHandler(wg, XtAllEvents, True, own_handler, h);

	XtAddEventHandler(wg,
		ButtonReleaseMask | ButtonPressMask | KeyPressMask |
		PointerMotionMask | EnterWindowMask | LeaveWindowMask,
		False, own_handler, g);
	XtVaSetValues(wg, XtNuserHandler, g, NULL);
}

/*	Select the function that does the actual redrawing	*/

#ifdef NEW_C
void w_set_redraw(Widget wg, void (*f)())
#else
void w_set_redraw(wg, f)
	Widget wg;
	void (*f)();
#endif
{
	XtRemoveAllCallbacks(wg, XtNredrawCallback);
	XtAddCallback(wg, XtNredrawCallback, f, NULL);
}

/*	Set colors	*/
#ifdef NEW_C
void w_set_fg_bg(Widget w, int fg, int bg)	
#else
void w_set_fg_bg(w, fg, bg)
	Widget w;
#endif
{
	XtVaSetValues(w,
		XtNbackground,	(Pixel)bg,	XtNforeground,	(Pixel)fg,
		NULL);
}

#ifdef NEW_C
void w_window_dim(Widget w, int *wp, int *hp)
#else
void w_window_dim(w, wp, hp)
	Widget w;
	int *wp, *hp;
#endif
{
	Dimension lwp, lhp;

	XtVaGetValues(w, XtNwidth, &lwp, XtNheight, &lhp, NULL);
	*wp = lwp;      *hp = lhp;
}
