/***********************************************************
Copyright 1995 by Theo Pavlidis

                        All Rights Reserved

Permission to use, copy and modify this software for personal use
is hereby granted.

This is EXPERIMENTAL SOFTWARE, still under development.
NO WARRANTIES OF ANY KIND ARE MADE ABOUT THIS SOFTWARE. It is
certain to contain bugs.
******************************************************************/

#ifndef STARTER

/*	Child_TYpe.h (Paper Widget Types used by paper_mate.c)	*/
#define NormalChild		0
#define PopupChild_P	1
#define PopupChild		2
#define IndependentChild 3
#define PopupChild_Q	4

/*	Image.h	*/
typedef unsigned char pPixel;

typedef struct image {
	pPixel *pstart;
	int width;
	int height;
	int depth;
	int ID;
	int pix_w;	/* used by halftoning process */
	int pixel_offset;	/* to accomodate other colors */
	int cmap_type;	/* used to avoid color amp duplicaitons */
	int cmap_len;
	pPixel *red, *green, *blue;
}  pImage;

/*	Menu.h (Definitions for Menus)	*/
struct action_pair {
	char *label;	/* item label */
	int (*fun)();	/* function called when selection is made */
};

struct value_pair {
	char *label;	/* item label */
	int value;	/* value returned when selection is made */
};

typedef struct action_pair pAction;
typedef struct value_pair  pValue;

/*	Pen.h (Definitions for Events)	*/
#define LEFT		 1 /* Left button pressed/released/dragged */
#define MIDDLE		 2 /* Middle button pressed/released/dragged */
#define RIGHT		 3 /* Right button pressed/released/dragged */
#define BTN_PRESS	 4 /* Left button pressed */
#define BTN_RELEASE	 8 /* Button (any) released */
#define MOVE		12 /* The pointing device moved */
#define DRAG		16 /* Pointing device moved with a button pressed */
#define KEY_RETURN	20 /* A return or new line  key was pressed */
#define KEY_ERASE	24 /* A back-space or delete key was pressed */
#define ESCAPE		28 /* The ``escape'' key was pressed */
#define KEY_NORMAL	32 /* A printable key was pressed on the keyboard */
#define NULL		 0 /* Default (action of no interest to the program) */
/*	Composite	kind+key	*/
#define LEFT_PRESS	 5 /* Left button pressed */
#define MIDDLE_PRESS	 6 /* Middle button pressed */
#define RIGHT_PRESS	 7 /* Right button pressed */
#define LEFT_RELEASE	 9 /* Left button pressed */
#define MIDDLE_RELEASE	10 /* Middle button pressed */
#define RIGHT_RELEASE	11 /* Right button pressed */
#define LEFT_DRAG	17 /* Pointing device moved with Left but. pressed */
#define MIDDLE_DRAG	18 /* Pointing device moved with Middle but. pressed */
#define RIGHT_DRAG	19 /* Pointing device moved with Right but. pressed */

struct pen {
	int x, y;	/* location of the cursor */
	int kind;	/* what kind of event occurred */
	char key;	/* what key was struck on the keyboard, if any */
	long origin;	/* where it came from (widget) */
};

typedef struct pen pEvent;

/*	Other definitions	*/
typedef struct {
	short x, y;
	} pPoint;

#define STARTER
#endif
