/*  This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "oracreator.h"

#include <QImage>

#include <kzip.h>

#include <kdebug.h>

extern "C"
{
    KDE_EXPORT ThumbCreator *new_creator()
    {
        return new OraCreator;
    }
}

OraCreator::OraCreator()
{
}

bool OraCreator::create(const QString &path, int width, int height, QImage &img)
{
	KZip zip (path);
	if(!zip.open(QIODevice::ReadOnly))
	{
		kDebug(0) << "zip.open()" << path << endl;
		return false;
	}

	const KArchiveEntry* thumbEntry = zip.directory()->entry("Thumbnails/thumbnail.png");
	if(!thumbEntry)
	{
		kDebug(0) << "thumb == NULL " << path << endl;
		return false;
	}

	if(thumbEntry->isDirectory())
	{
		kDebug(0) << "thumbEntry.isDirectory() " << path << endl;
		return false;
	}

	const KZipFileEntry* thumbnail = static_cast<const KZipFileEntry *>(thumbEntry);
	if(!thumbnail)
	{
		kDebug(0) << "thumbnail == NULL: " << path << endl;
		return false;
	}

	if(!img.loadFromData(thumbnail->data()))
	{
		kDebug(0) << "img.load(): " << path << endl;
		return false;
	}

	if(img.depth() != 32)
	{
		img = img.convertToFormat(QImage::Format_RGB32);
	}

	kDebug(0) << "Thumbnail for " << path << " created" << endl;
	return true;
}

ThumbCreator::Flags OraCreator::flags() const
{
	return None;
}
