/******************************************************************************\
 This program tests geometry implementation. It creates a window with a single
 button which toggles the size of the window. The point of the gravity hint
 is to keep the bottom of the window in the same location.

 Michael Levin, 4/29/2009
\******************************************************************************/

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

static int toggle;

static void button_clicked(GtkButton *button, GtkWidget *window)
{       GdkScreen *screen;
        GdkRectangle dest;

        toggle = !toggle;
        gtk_window_resize(GTK_WINDOW(window), 200, toggle ? 240 : 40);
		screen=gdk_screen_get_default();
		//gdk_screen_get_monitor_workarea(screen,0,dest);//gtk3
		gdk_screen_get_monitor_geometry(screen,0,&dest);//gtk2
		gtk_window_move(GTK_WINDOW(window), dest.x,dest.height);
}

int main(int argc, char **argv)
{
        GtkWidget *window, *button;
        GdkGeometry geometry;


        gtk_init(&argc, &argv);

        /* Create window */
        window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        g_signal_connect(G_OBJECT(window), "delete-event", G_CALLBACK(exit),
                         NULL);
        gtk_window_set_default_size(GTK_WINDOW(window), 200, 40);

        /* This code is supposed to make the window auto-resize with respect
           to the bottom edge */
        geometry.win_gravity = GDK_GRAVITY_SOUTH_WEST;
        gtk_window_set_geometry_hints(GTK_WINDOW(window), window, &geometry,
                                      GDK_HINT_WIN_GRAVITY);

        /* Create button */
        button = gtk_button_new_with_label("Resize Toggle");
        g_signal_connect(G_OBJECT(button), "clicked",
                         G_CALLBACK(button_clicked), window);
        gtk_container_add(GTK_CONTAINER(window), button);
        gtk_widget_show(button);


        gtk_widget_show(window);
        gtk_main();
        return 0;
}

