/* $Id$ */
/*-
 * Copyright (c) 2003-2005 Benedikt Meurer <benny@xfce.org>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __EXO_OPEN_HELPER_DATABASE_H__
#define __EXO_OPEN_HELPER_DATABASE_H__

G_BEGIN_DECLS;

typedef struct _ExoOpenHelperCategoryClass ExoOpenHelperCategoryClass;
typedef struct _ExoOpenHelperCategory      ExoOpenHelperCategory;

#define EXO_OPEN_TYPE_HELPER_CATEGORY (exo_open_helper_category_get_type ())

GType        exo_open_helper_category_get_type        (void) G_GNUC_CONST;

const gchar *exo_open_helper_category_get_id          (ExoOpenHelperCategory *category);
const gchar *exo_open_helper_category_get_name        (ExoOpenHelperCategory *category);
const gchar *exo_open_helper_category_get_description (ExoOpenHelperCategory *category);
void         exo_open_helper_category_get_custom      (ExoOpenHelperCategory *category,
                                                       gchar                **custom_application,
                                                       gchar                **custom_parameters);

gboolean     exo_open_helper_category_execute         (ExoOpenHelperCategory *category,
                                                       const gchar           *parameter,
                                                       GError               **error);


typedef struct _ExoOpenHelperDatabaseClass ExoOpenHelperDatabaseClass;
typedef struct _ExoOpenHelperDatabase      ExoOpenHelperDatabase;

#define EXO_OPEN_TYPE_HELPER_DATABASE             (exo_open_helper_database_get_type ())
#define EXO_OPEN_HELPER_DATABASE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), EXO_OPEN_TYPE_HELPER_DATABASE, ExoOpenHelperDatabase))
#define EXO_OPEN_HELPER_DATABASE_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), EXO_OPEN_TYPE_HELPER_DATABASE, ExoOpenHelperDatabaseClass))
#define EXO_OPEN_IS_HELPER_DATABASE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EXO_OPEN_TYPE_HELPER_DATABASE))
#define EXO_OPEN_IS_HELPER_DATABASE_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), EXO_OPEN_TYPE_HELPER_DATABASE))
#define EXO_OPEN_HELPER_DATABASE_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), EXO_OPEN_TYPE_HELPER_DATABASE, ExoOpenHelperDatabaseClass))

GType                  exo_open_helper_database_get_type    (void) G_GNUC_CONST;

ExoOpenHelperDatabase *exo_open_helper_database_get_default (void);

G_END_DECLS;

#endif /* !__EXO_OPEN_HELPER_DATABASE_H__ */
