/* $Id$ */
/*-
 * Copyright (c) 2003-2005 Benedikt Meurer <benny@xfce.org>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <exo-open/exo-open-helper-database.h>



static void                   exo_open_helper_category_class_init (ExoOpenHelperCategoryClass *klass);
static void                   exo_open_helper_category_init       (ExoOpenHelperCategory      *category);
static ExoOpenHelperCategory *exo_open_helper_category_new        (const gchar                *id,
                                                                   const gchar                *name,
                                                                   const gchar                *fallback,
                                                                   const gchar                *description);



struct _ExoOpenHelperCategoryClass
{
  GObjectClass __parent__;
};

struct _ExoOpenHelperCategory
{
  GObject __parent__;

  const gchar *id;
  const gchar *name;
  const gchar *fallback;
  const gchar *description;
};



G_DEFINE_TYPE (ExoOpenHelperCategory, exo_open_helper_category, G_TYPE_OBJECT);



static void
exo_open_helper_category_class_init (ExoOpenHelperCategoryClass *klass)
{
}



static void
exo_open_helper_category_init (ExoOpenHelperCategory *category)
{
}



static ExoOpenHelperCategory*
exo_open_helper_category_new (const gchar *id,
                              const gchar *name,
                              const gchar *fallback,
                              const gchar *description)
{
  ExoOpenHelperCategory *category;

  /* allocate the new helper category object */
  category = g_object_new (EXO_OPEN_TYPE_HELPER_CATEGORY, NULL);
  category->id = id;
  category->name = name;
  category->fallback = fallback;
  category->description = description;

  return category;
}



/**
 * exo_open_helper_category_get_id:
 * @category : an #ExoOpenHelperCategory.
 * Return value: the type id of the @category.
 **/
const gchar*
exo_open_helper_category_get_id (const ExoOpenHelperCategory *category)
{
  g_return_val_if_fail (EXO_OPEN_IS_HELPER_CATEGORY (category), NULL);
  return category->id;
}



/**
 * exo_open_helper_category_get_name:
 * @category : an #ExoOpenHelperCategory.
 * Return value: the (translated) name of the @category.
 **/
const gchar*
exo_open_helper_category_get_name (const ExoOpenHelperCategory *category)
{
  g_return_val_if_fail (EXO_OPEN_IS_HELPER_CATEGORY (category), NULL);
  return category->name;
}



/**
 * exo_open_helper_category_get_description:
 * @category : an #ExoOpenHelperCategory.
 * Return value: the (translated) description of the @category.
 **/
const gchar*
exo_open_helper_category_get_description (const ExoOpenHelperCategory *category)
{
  g_return_val_if_fail (EXO_OPEN_IS_HELPER_CATEGORY (category), NULL);
  return category->description;
}




static void exo_open_helper_database_class_init (ExoOpenHelperDatabaseClass *klass);
static void exo_open_helper_database_init       (ExoOpenHelperDatabase      *database);
static void exo_open_helper_database_finalize   (GObject                    *object);



struct _ExoOpenHelperDatabaseClass
{
  GObjectClass __parent__;
};

struct _ExoOpenHelperDatabase
{
  GObject __parent__;

  GHashTable *categories;
};



/* The predefined helper categories */
static const struct
{
  const gchar *id;
  const gchar *name;
  const gchar *fallback;
  const gchar *description;
} CATEGORIES[] = {
  { "WebBrowser", N_("Web Browser"), "firefox.desktop", N_("The preferred Web Browser will be used to open hyperlinks."), },
  { "MailReader", N_("Mail Reader"), "thunderbird.desktop", N_("The preferred Mail Reader will be used to compose mails."), },
  { "TerminalEmulator", N_("Terminal Emulator"), "Terminal.desktop", N_("The preferred Terminal Emulator will be used to run CLI programs."), },
};



G_DEFINE_TYPE (ExoOpenHelperDatabase, exo_open_helper_database, G_TYPE_OBJECT);



static void
exo_open_helper_database_class_init (ExoOpenHelperDatabaseClass *klass)
{
  GObjectClass *gobject_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = exo_open_helper_database_finalize;
}



static void
exo_open_helper_database_init (ExoOpenHelperDatabase *database)
{
  ExoOpenHelperCategory *category;
  guint                  n;

  /* initialize the categories */
  database->categories = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, g_object_unref);
  for (n = 0; n < G_N_ELEMENTS (CATEGORIES); ++n)
    {
      category = exo_open_helper_category_new (CATEGORIES[n].id, _(CATEGORIES[n].name), CATEGORIES[n].fallback, _(CATEGORIES[n].description));
      g_hash_table_replace (database->categories, exo_open_helper_category_get_id (category), category);
    }
}



static void
exo_open_helper_database_finalize (GObject *object)
{
  ExoOpenHelperDatabase *database = EXO_OPEN_HELPER_DATABASE (object);

  g_hash_table_destroy (database->categories);

  (*G_OBJECT_CLASS (exo_open_helper_database_parent_class)->finalize) (object);
}




