/* $Id$ */
/*-
 * Copyright (c) 2005 Benedikt Meurer <benny@xfce.org>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __THUNAR_ZOOM_LEVEL_H__
#define __THUNAR_ZOOM_LEVEL_H__

#include <glib-object.h>

G_BEGIN_DECLS;

#define THUNAR_TYPE_ZOOM_LEVEL (thunar_zoom_level_get_type ())
#define THUNAR_TYPE_ICON_SIZE  (thunar_icon_size_get_type ())

/**
 * ThunarZoomLevel:
 * @THUNAR_ZOOM_LEVEL_SMALLEST : smallest possible zoom level.
 * @THUNAR_ZOOM_LEVEL_SMALLER  : smaller zoom level.
 * @THUNAR_ZOOM_LEVEL_SMALL    : small zoom level.
 * @THUNAR_ZOOM_LEVEL_NORMAL   : the default zoom level.
 * @THUNAR_ZOOM_LEVEL_LARGE    : large zoom level.
 * @THUNAR_ZOOM_LEVEL_LARGER   : larger zoom level.
 * @THUNAR_ZOOM_LEVEL_LARGEST  : largest possible zoom level.
 *
 * Lists the various zoom levels supported by Thunar's
 * folder views.
 **/
typedef enum /*< skip >*/
{
  THUNAR_ZOOM_LEVEL_SMALLEST, /*< nick=smallest >*/
  THUNAR_ZOOM_LEVEL_SMALLER,  /*< nick=smaller >*/
  THUNAR_ZOOM_LEVEL_SMALL,    /*< nick=small >*/
  THUNAR_ZOOM_LEVEL_NORMAL,   /*< nick=normal >*/
  THUNAR_ZOOM_LEVEL_LARGE,    /*< nick=large >*/
  THUNAR_ZOOM_LEVEL_LARGER,   /*< nick=larger >*/
  THUNAR_ZOOM_LEVEL_LARGEST,  /*< nick=largest >*/

  /*< private >*/
  THUNAR_ZOOM_N_LEVELS,       /*< skip >*/
} ThunarZoomLevel;

/**
 * ThunarIconSize:
 * @THUNAR_ICON_SIZE_SMALLEST : icon size for #THUNAR_ZOOM_LEVEL_SMALLEST.
 * @THUNAR_ICON_SIZE_SMALLER  : icon size for #THUNAR_ZOOM_LEVEL_SMALLER.
 * @THUNAR_ICON_SIZE_SMALL    : icon size for #THUNAR_ZOOM_LEVEL_SMALL.
 * @THUNAR_ICON_SIZE_NORMAL   : icon size for #THUNAR_ZOOM_LEVEL_NORMAL.
 * @THUNAR_ICON_SIZE_LARGE    : icon size for #THUNAR_ZOOM_LEVEL_LARGE.
 * @THUNAR_ICON_SIZE_LARGER   : icon size for #THUNAR_ZOOM_LEVEL_LARGER.
 * @THUNAR_ICON_SIZE_LARGEST  : icon size for #THUNAR_ZOOM_LEVEL_LARGEST.
 *
 * Icon sizes matching the various #ThunarZoomLevel<!---->s.
 **/
typedef enum /*< skip >*/
{
  THUNAR_ICON_SIZE_SMALLEST = 16,
  THUNAR_ICON_SIZE_SMALLER  = 24,
  THUNAR_ICON_SIZE_SMALL    = 36,
  THUNAR_ICON_SIZE_NORMAL   = 48,
  THUNAR_ICON_SIZE_LARGE    = 64,
  THUNAR_ICON_SIZE_LARGER   = 72,
  THUNAR_ICON_SIZE_LARGEST  = 96,
} ThunarIconSize;

GType          thunar_zoom_level_get_type     (void) G_GNUC_CONST;
GType          thunar_icon_size_get_type      (void) G_GNUC_CONST;

ThunarIconSize thunar_zoom_level_to_icon_size (ThunarZoomLevel zoom_level) G_GNUC_CONST;

G_END_DECLS;

#endif /* !__THUNAR_ZOOM_LEVEL_H__ */
