/* $Id: thunar-extension-manager.h 17553 2005-09-11 00:07:08Z benny $ */
/*-
 * Copyright (c) 2005 Benedikt Meurer <benny@xfce.org>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __THUNAR_EXTENSION_MANAGER_H__
#define __THUNAR_EXTENSION_MANAGER_H__

#include <glib-object.h>

G_BEGIN_DECLS;

typedef struct _ThunarExtensionManagerClass ThunarExtensionManagerClass;
typedef struct _ThunarExtensionManager      ThunarExtensionManager;

#define THUNAR_TYPE_EXTENSION_MANAGER             (thunar_extension_manager_get_type ())
#define THUNAR_EXTENSION_MANAGER(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), THUNAR_TYPE_EXTENSION_MANAGER, ThunarExtensionManager))
#define THUNAR_EXTENSION_MANAGER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), THUNAR_TYPE_EXTENSION_MANAGER, ThunarExtensionManagerClass))
#define THUNAR_IS_EXTENSION_MANAGER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), THUNAR_TYPE_EXTENSION_MANAGER))
#define THUNAR_IS_EXTENSION_MANAGER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), THUNAR_TYPE_EXTENSION_MANAGER))
#define THUNAR_EXTENSION_MANAGER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), THUNAR_TYPE_EXTENSION_MANAGER, ThunarExtensionManagerClass))

GType                   thunar_extension_manager_get_type       (void) G_GNUC_CONST;

ThunarExtensionManager *thunar_extension_manager_get_default    (void);

GList                  *thunar_extension_manager_list_providers (ThunarExtensionManager *manager,
                                                                 GType                   type);

G_END_DECLS;

#endif /* !__THUNAR_EXTENSION_MANAGER_H__ */
