/* $Id: thunar-vfs.h 17328 2005-09-03 22:47:13Z benny $ */
/*-
 * Copyright (c) 2005 Benedikt Meurer <benny@xfce.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __THUNAR_VFS_H__
#define __THUNAR_VFS_H__

#define THUNAR_VFS_INSIDE_THUNAR_VFS_H

#include <thunar-vfs/thunar-vfs-enum-types.h>
#include <thunar-vfs/thunar-vfs-info.h>
#include <thunar-vfs/thunar-vfs-interactive-job.h>
#include <thunar-vfs/thunar-vfs-job.h>
#include <thunar-vfs/thunar-vfs-mime-application.h>
#include <thunar-vfs/thunar-vfs-mime-database.h>
#include <thunar-vfs/thunar-vfs-mime-info.h>
#include <thunar-vfs/thunar-vfs-monitor.h>
#include <thunar-vfs/thunar-vfs-path.h>
#include <thunar-vfs/thunar-vfs-scandir.h>
#include <thunar-vfs/thunar-vfs-user.h>
#include <thunar-vfs/thunar-vfs-util.h>
#include <thunar-vfs/thunar-vfs-volume.h>

#undef THUNAR_VFS_INSIDE_THUNAR_VFS_H

G_BEGIN_DECLS;

void          thunar_vfs_init     (void);
void          thunar_vfs_shutdown (void);

ThunarVfsJob *thunar_vfs_listdir  (ThunarVfsPath *path,
                                   GError       **error);

ThunarVfsJob *thunar_vfs_copy     (GList         *source_path_list,
                                   ThunarVfsPath *target_path,
                                   GError       **error);

ThunarVfsJob *thunar_vfs_move     (GList         *source_path_list,
                                   ThunarVfsPath *target_path,
                                   GError       **error);

ThunarVfsJob *thunar_vfs_unlink   (GList         *path_list,
                                   GError       **error);

G_END_DECLS;

#endif /* !__THUNAR_VFS_H__ */
