static void 
print_version (void){
	GString *print_text = g_string_new("\tThis is %s version %s (revision %s) for Xfce %s\n\tReleased under the terms of the GNU General Public License.\n\tCompiled against GTK+-%d.%d.%d, using GTK+-%d.%d.%d.\n\n\tBuild configuration and supported features:\n");
	const gchar yes[6] = "Yes\n", no[5] = "No\n";

	g_string_append(print_text, "\t- Startup notification support:                 ");
	#ifdef HAVE_LIBSTARTUP_NOTIFICATION
	g_string_append(print_text, yes);
	#else
	g_string_append(print_text, no);
	#endif

	g_string_append(print_text, "\t- XSync support:                                ");
	#ifdef HAVE_XSYNC
	g_string_append(print_text, yes);
	#else
	g_string_append(print_text, no);
	#endif

	g_string_append(print_text, "\t- Render support:                               ");
	#ifdef HAVE_RENDER
	g_string_append(print_text, yes);
	#else
	g_string_append(print_text, no);
	#endif
	
	g_string_append(print_text, "\t- Xrandr support:                               ");
	#ifdef HAVE_RANDR
	g_string_append(print_text, yes);
	#else
	g_string_append(print_text, no);
	#endif

	g_string_append(print_text, "\t- Embedded compositor:                          ");
	#ifdef HAVE_COMPOSITOR
	g_string_append(print_text, yes);
	#else
	g_string_append(print_text, no);
	#endif

	g_string_append(print_text, "\t- KDE systray proxy (deprecated):               ");
	#ifdef ENABLE_KDE_SYSTRAY_PROXY
	g_string_append(print_text, yes);
	#else
	g_string_append(print_text, no);
	#endif

	gchar *print_text_string = g_string_free(print_text, FALSE);
	g_print(print_text_string, PACKAGE, VERSION, REVISION, xfce_version_string(), GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION, gtk_major_version, gtk_minor_version, gtk_micro_version);
	g_free(print_text_string);
}
